/***************************************************************************
 morphos.c Copyright (C) 2002 Ruediger Hanke


 This program may be modified and copied freely according to the terms of
 the GNU general public license (GPL), as long as the above copyright
 notice and the licensing information contained herein are preserved.

 Please refer to www.gnu.org for licensing details.

 This work is provided AS IS, without warranty of any kind, expressed or
 implied, including but not limited to the warranties of merchantibility,
 noninfringement, and fitness for a specific purpose. The author will not
 be held liable for any damage caused by this work or derivatives of it.

 By using this source code, you agree to the licensing terms as stated
 above.

***************************************************************************/

#include <clib/amiga_protos.h>
#include <proto/dos.h>
#include <fcntl.h>

int creat(const char *path, mode_t mode)
{
	return open(path, O_WRONLY|O_CREAT|O_TRUNC);
}

void usleep( u_int msec )
{
	TimeDelay(UNIT_MICROHZ, msec/1000000, msec % 1000000);
}

unsigned sleep( unsigned time )
{
	Delay(time*50);
	return 0;
}
