/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Morozhnikov   *
 *   dmiceman@mail.ru   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <linux/stat.h>

#include <linux/iso_fs.h>

#define FUSE_USE_VERSION 22
#include <fuse.h>

#include <zlib.h>

#include "isofs.h"

#ifdef __GNUC__
# define UNUSED(x) x __attribute__((unused))
#else
# define UNUSED(x) x
#endif

static char *imagefile = NULL;
static int image_fd = -1;

static int isofs_getattr(const char *path, struct stat *stbuf)
{
    return isofs_real_getattr(path, stbuf);
}

static int isofs_readlink(const char *path, char *target, size_t size) {
    return isofs_real_readlink(path, target, size);
};

static int isofs_open(const char *path, struct fuse_file_info *UNUSED(fi))
{
    return isofs_real_open(path);
}

static int isofs_read(const char *path, char *buf, size_t size,
                     off_t offset, struct fuse_file_info *UNUSED(fi))
{
    return isofs_real_read(path, buf, size, offset);
}

static int isofs_flush(const char *UNUSED(path), struct fuse_file_info *UNUSED(fi)) {
    return 0;
};

static void* isofs_init() {
    return isofs_real_init(imagefile, image_fd);
};

static int isofs_opendir(const char *path, struct fuse_file_info *UNUSED(fi)) {
    return isofs_real_opendir(path);
};

static int isofs_readdir(const char *path, void *buf, fuse_fill_dir_t filler, off_t UNUSED(offset),
    struct fuse_file_info *UNUSED(fi)) {
    return isofs_real_readdir(path, buf, filler);
};

static int isofs_statfs(const char *UNUSED(path), struct statfs *stbuf)
{
    return isofs_real_statfs(stbuf);
}

static struct fuse_operations isofs_oper = {
    .getattr    = isofs_getattr,
    .readlink   = isofs_readlink,
    .open       = isofs_open,
    .read       = isofs_read,
    .flush      = isofs_flush,
    .init       = isofs_init,
    .opendir    = isofs_opendir,
    .readdir    = isofs_readdir,
    .statfs     = isofs_statfs,
};

int main(int argc, char *argv[])
{
    if(argc < 3) {
        printf("Version: %s\nUsage: %s <isofs_image_file> <mount_point> [<FUSE library options>]\n", 
            VERSION, 
            argv[0]);
        exit(EINVAL);
    };
    
    imagefile = argv[1];
    
    image_fd = open(imagefile, O_RDONLY);
    if(image_fd == -1) {
        perror("open image file");
        exit(EINVAL);
    };

    char **nargv = (char **) malloc(argc * sizeof(char *));
    int nargc = argc - 1;
    
    nargv[0] = argv[0];
    
    int i;
    
    for(i = 0; i < nargc; i++) {
        nargv[i + 1] = argv[i + 2];
    };
    
    return fuse_main(nargc, nargv, &isofs_oper);
}
