/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Morozhnikov   *
 *   dmiceman@mail.ru   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <linux/stat.h>

#include "isofs.h"

int filler(void *buf, char *name, struct stat *st, off_t off) {
    if(st) {
        printf(
            "%c%c%c%c%c%c%c%c%c ",
            (S_ISDIR(st->st_mode) ? 'd' : '-'),
            ((st->st_mode & S_IRUSR) ? 'r' : '-'),
            ((st->st_mode & S_IWUSR) ? 'w' : '-'),
            ((st->st_mode & S_IXUSR) ? 'x' : '-'),
            ((st->st_mode & S_IRGRP) ? 'r' : '-'),
            ((st->st_mode & S_IWGRP) ? 'w' : '-'),
            ((st->st_mode & S_IXGRP) ? 'x' : '-'),
            ((st->st_mode & S_IROTH) ? 'r' : '-'),
            ((st->st_mode & S_IWOTH) ? 'w' : '-'),
            ((st->st_mode & S_IXOTH) ? 'x' : '-')
        );
    };
    printf("%s\n", name);
    return 0;
};

static int image_fd = -1;

int main(int argc, char *argv[])
{
    if(argc < 2) {
        printf("Version: %s\nUsage: %s <isofs_image_file>\n", 
            VERSION, 
            argv[0]);
        exit(EINVAL);
    };
    
    char *imagefile = argv[1];
    
    image_fd = open(imagefile, O_RDONLY);
    if(image_fd == -1) {
        perror("open image file");
        exit(EINVAL);
    };

    isofs_context *context = isofs_real_init(imagefile, image_fd);
    
    printf("primary descriptor type: %d (%s)\n", isonum_711(context->pd.type), 
        (isonum_711(context->pd.type) == ISO_VD_PRIMARY ? "OK" : "FAIL!"));
    printf("block size: %d\n", context->block_size);
    printf("size of root directory record: %d\n", isonum_711(context->root->length));
    printf("size of root directory content: %d\n", isonum_733(context->root->size));
    
    int rc = isofs_real_readdir("/", NULL, filler);
    if(rc) {
        errno = -rc;
        perror(NULL);
        return -rc;
    };
    
    return 0;
}
