/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: RuleOptionsDialog.cpp,v 1.7.4.2 2005/09/13 04:55:41 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"
#include "platforms.h"

#include "RuleOptionsDialog.h"
#include "ObjectManipulator.h"
#include "RuleSetView.h"
#include "FWWindow.h"

#include "fwbuilder/Firewall.h"
#include "fwbuilder/Rule.h"
#include "fwbuilder/FWOptions.h"
#include "fwbuilder/Resources.h"
#include "fwbuilder/Rule.h"

#include <qwidgetstack.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qmessagebox.h>
#include <qregexp.h>

#include <iostream>

using namespace libfwbuilder;
using namespace std;

RuleOptionsDialog::RuleOptionsDialog(QWidget *parent) : RuleOptionsDialog_q(parent) {}

void RuleOptionsDialog::loadFWObject(FWObject *o)
{
    obj=o;
//    rsv=rv;

    FWObject *p=obj;
    while ( !Firewall::isA(p) ) p=p->getParent();
    platform=p->getStr("platform").c_str();

    Rule      *rule = dynamic_cast<Rule*>(o);
    FWOptions *ropt = rule->getOptionsObject();

    int wid=0;
    if (platform=="iptables") wid=0;
    if (platform=="ipf")      wid=1;
    if (platform=="pf")       wid=2;
    if (platform=="ipfw")     wid=3;
    if (platform=="pix" || platform=="fwsm")      wid=4;

    wStack->raiseWidget( wid );
    wStack->widget(wid)->show();

    QStringList  logLevels=getLogLevels( obj->getStr("platform").c_str() );
    ipt_logLevel->clear();
    ipt_logLevel->insertStringList(getScreenNames(logLevels));
    ipf_logLevel->clear();
    ipf_logLevel->insertStringList(getScreenNames(logLevels));
    pix_logLevel->clear();
    pix_logLevel->insertStringList(getScreenNames(logLevels));

    QStringList  logFacilities=getLogFacilities( obj->getStr("platform").c_str() );
    ipf_logFacility->clear();
    ipf_logFacility->insertStringList(getScreenNames(logFacilities));    

    QStringList actionsOnReject=getActionsOnReject( obj->getStr("platform").c_str() );
    ipt_actionOnReject->clear();
    ipt_actionOnReject->insertStringList(getScreenNames(actionsOnReject));
    ipf_actionOnReject->clear();
    ipf_actionOnReject->insertStringList(getScreenNames(actionsOnReject));
    pf_actionOnReject->clear();
    pf_actionOnReject->insertStringList(getScreenNames(actionsOnReject));
    ipfw_actionOnReject->clear();
    ipfw_actionOnReject->insertStringList(getScreenNames(actionsOnReject));

    QStringList limitSuffixes=getLimitSuffixes( obj->getStr("platform").c_str() );
    ipt_limitSuffix->clear();
    ipt_limitSuffix->insertStringList(getScreenNames(limitSuffixes));
    
    
    data.clear();
    
    if (platform=="iptables")
    {
        data.registerOption( ipt_logPrefix            , ropt,  "log_prefix" );
        data.registerOption( ipt_logLevel             , ropt,  "log_level", logLevels );
        data.registerOption( ipt_nlgroup              , ropt,  "ulog_nlgroup" );
        data.registerOption( ipt_rule_name_accounting , ropt,  "rule_name_accounting" );
        data.registerOption( ipt_actionOnReject       , ropt,  "action_on_reject" ,actionsOnReject);
        data.registerOption( ipt_limit                , ropt,  "limit_value" );
        data.registerOption( ipt_limitSuffix          , ropt,  "limit_suffix", limitSuffixes);
        data.registerOption( ipt_burst                , ropt,  "limit_burst" );
        data.registerOption( ipt_assumeFwIsPartOfAny  , ropt,  "firewall_is_part_of_any_and_networks" );
        data.registerOption( ipt_stateless            , ropt,  "stateless" );

        bool f=false;
        if (PolicyRule::isA(rule))
            f = (PolicyRule::cast(rule)->getAction()==PolicyRule::Accounting);
        ipt_rule_name_accounting->setEnabled(f);
    }


    if (platform=="ipf")
    {
        data.registerOption( ipf_logFacility     , ropt,  "ipf_log_facility", logFacilities);
        data.registerOption( ipf_logLevel        , ropt,  "log_level" , logLevels);
        data.registerOption( ipf_actionOnReject  , ropt,  "action_on_reject", actionsOnReject);
        data.registerOption( ipf_masq_icmp       , ropt,  "ipf_return_icmp_as_dest");
        data.registerOption( ipf_stateless       , ropt,  "stateless" );
        data.registerOption( ipf_keep_frags      , ropt,  "ipf_keep_frags" );
    }

    if (platform=="pf")
    {
        data.registerOption( pf_logPrefix        , ropt,  "log_prefix" );
        data.registerOption( pf_actionOnReject   , ropt,  "action_on_reject",actionsOnReject);
        data.registerOption( pf_stateless        , ropt,  "stateless" );
        data.registerOption( pf_rule_max_state   , ropt,  "pf_rule_max_state" );
        data.registerOption( pf_source_tracking  , ropt,  "pf_source_tracking" );
        data.registerOption( pf_max_src_nodes    , ropt,  "pf_max_src_nodes" );
        data.registerOption( pf_max_src_states   , ropt,  "pf_max_src_states" );
    }

    if (platform=="ipfw")
    {
        data.registerOption( ipfw_actionOnReject , ropt,"action_on_reject",actionsOnReject);
        data.registerOption( ipfw_stateless      , ropt,"stateless" );
    }

    if (platform=="pix" || platform=="fwsm")
    {
        string vers="version_"+p->getStr("version");
        if ( Resources::platform_res[platform]->getResourceBool(
              "/FWBuilderResources/Target/options/"+vers+"/pix_rule_syslog_settings"))
        {
            pix_disable_rule_log->setEnabled(true);
            pix_logLevel->setEnabled(true);
            pix_log_interval->setEnabled(true);

            data.registerOption( pix_disable_rule_log, ropt,"disable_logging_for_this_rule" );
            data.registerOption( pix_logLevel        , ropt,"log_level" ,logLevels);
            data.registerOption( pix_log_interval    , ropt,"log_interval" );
        } else
        {
            pix_disable_rule_log->setEnabled(false);
            pix_logLevel->setEnabled(false);
            pix_log_interval->setEnabled(false);
        }

    }

    init=true;
    data.loadAll();

    pf_max_src_nodes->setEnabled( pf_source_tracking->isChecked() );
    pf_max_src_states->setEnabled( pf_source_tracking->isChecked() );

    apply->setEnabled( false );
    init=false;
}
    
void RuleOptionsDialog::changed()
{
    apply->setEnabled( true );

    pf_max_src_nodes->setEnabled( pf_source_tracking->isChecked() );
    pf_max_src_states->setEnabled( pf_source_tracking->isChecked() );
}

void RuleOptionsDialog::validate(bool *res)
{
    *res=true;
}

void RuleOptionsDialog::isChanged(bool *res)
{
    *res=(!init && apply->isEnabled());
}

void RuleOptionsDialog::libChanged()
{
    changed();
}

void RuleOptionsDialog::applyChanges()
{
    if (!isTreeReadWrite(this,obj)) return;

    if (platform=="iptables")
    {
        QString rn = ipt_rule_name_accounting->text();
/* rule name for accounting may contain only alphanumeric characters
 * and no white spaces or spec. characters
 */
        if (rn.contains(QRegExp("[^a-zA-Z0-9_]"))!=0)
        {
            QMessageBox::information(
                this,"Firewall Builder", 
                tr("Rule name for accounting is converted to the iptables\nchain name and therefore may not contain white space\nand special characters."),
                tr("&Continue"), QString::null,QString::null,
                0, 1 );

            return;
        }
    }

    init=true;
    data.saveAll();
    init=false;

    mw->updateRuleOptions();

    apply->setEnabled( false );
}

void RuleOptionsDialog::discardChanges()
{
    loadFWObject(obj);
}


/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void RuleOptionsDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}

