/* GnuTLSAdapter.hh
 * GnuTLS adapter for TCP connection
 *
 * Copyright (C) 2004 Goedson Paixao
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef INCL_GNUTLS_ADAPTER_HH
#define INCL_GNUTLS_ADAPTER_HH

#include <string>
#include <glib.h>
#include <gnutls/gnutls.h>

#include "SSLAdapter.hh"

namespace Gabber {

class GnuTLSAdapter: public SSLAdapter
{
public:
     GnuTLSAdapter();
  
     virtual void disconnect();
     virtual GIOStatus send(const gchar* data, const gsize len, gsize* written);
     virtual GIOStatus read(gchar* buffer, const gsize count, gsize* bytes_read);
     virtual bool registerSocket(const gint socket);
     virtual void freeResources();

private:
     gnutls_certificate_credentials _cred;
     gnutls_session            _session;
};

};

#endif /* INCL_GNUTLS_TRANSMITTER_HH */
