/*
 * cfgmgt.h
 * Thomas Nemeth, le 25.09.1999
 *
 * HEADER
 * Gestion de la configuration de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _CFGMGT_H_
#define _CFGMGT_H_


/* Charge le contenu du fichier de configuration                      */
/* Load the configuration file                                        */
void load_config (char *filename);

/* crit le fichier de configuration                                  */
/* Write the configuration file                                       */
void write_config ();

/* Cre le rpertoire de configuration et de stockage des fichiers   */
/* Create the configuration and file storage directory                */
void create_directory ();

/* Diffrentes foncions pour grer la configuration                   */
/* Different functions to manage configuration                        */
void config_set_cat_filename (const char *cat_filename);
void config_set_acc_filename (const char *acc_filename);
void config_set_trs_filename (const char *trs_filename);
void config_set_currency (const char *currency);
void config_set_currency_pos (int currency_pos);
void config_set_last_opened_acc (int last_opened_acc);
void config_set_use_last_acc (int use_last_acc);
void config_set_auto_save (int auto_save);
void config_set_tear_off (int tear_off);
void config_set_date_format (int date_format);
void config_set_date_separator (const char *date_separator);
void config_set_decimal_point (const char *decimal_point);
void config_set_euro_value (float euro_value);
void config_set_advanced (int advanced);
void config_set_ps_prn_cmd (const char *ps_cmd);
void config_set_ps_prn_opt (const char *ps_opt);
void config_set_asc_prn_cmd (const char *asc_cmd);
void config_set_asc_prn_opt (const char *asc_opt);

/* Vrifie si l'option Advanced contient advanced_feature           */
/* Verify if the "Advanced" option contains advanced_feature          */
int advanced_contains (int advanced_feature);

/* Vide la mmoire et le nom du fichier portefeuille                  */
/* Empty the memory and the wallet file name                          */
void new_wallet ();

#endif
