/*
 * locale_formats.h
 * Thomas Nemeth, le 10.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _LOCALE_FORMATS_H_
#define _LOCALE_FORMATS_H_

/*
  save current locale from LC_ALL and LC_NUMERIC
*/
char *all_locale;
char *num_locale;

/*
 * format date according to the configuration's selected format
 * eg : "dd.mm.yyyy"
 *
 */
char *format_date (const char *date);

/*
 * format date according to the configuration's selected format
 * eg : "dd.mm.yy"
 *
 */
char *format_short_date (const char *date);

/*
 * format date according to the configuration's selected format
 * eg : "dd.mm"
 *
 */
char *format_very_short_date (const char *date);

/*
 * set the date from locale format to standard format
 * eg : dd.mm.yyyy -> "yyyymmdd"
 *
 */
char *unformat_date (const char *date);

/*
 * get the locale formated date for today
 *
 */
char *format_today ();

/*
 * get the locale unformated date for today ("yyyymmdd")
 *
 */
char *unformat_today ();

/*
 * format amount of money according to the configuration's selected format
 * eg : "100.00 F" or "$ 500.00"
 *
 */
char *format_amount (float amount);
float get_amount (char *amountstr);
char *format_euro_value (float amount);

/*
 * get the day's number from an unformated date
 * eg : dd.mm.yyyy -> "dd"
 *
 */
char *get_day (const char *date);

/*
 * get the month's name from an integer number of month (0..11)
 * eg : mm -> "month name"
 *
 */
char *get_month_ni (int month);

/*
 * get the month's name from an unformated date
 * eg : dd.mm.yyyy -> mm -> "month name"
 *
 */
char *get_month_n (const char *date);

/*
 * get the month's number from an unformated date
 * eg : dd.mm.yyyy -> "mm"
 *
 */
char *get_month (const char *date);

/*
 * get the year's number from an unformated date
 * eg : dd.mm.yyyy -> "yyyy"
 *
 */
char *get_year (const char *date);

/*
 * get the day's number from an unformated date
 * eg : dd.mm.yyyy -> dd
 *
 */
int get_day_i (const char *date);

/*
 * get the month's number from an unformated date
 * eg : dd.mm.yyyy -> mm
 *
 */
int get_month_i (const char *date);

/*
 * get the year's number from an unformated date
 * eg : dd.mm.yyyy -> yyyy
 *
 */
int get_year_i (const char *date);

/*
 * get a formated date from a long integer that is in
 * yyyymmdd format -> "dd.mm.yyyy"
 *
 */
char *int_to_date_f (long int date);

/*
 * get a unformated date from a long integer that is in
 * yyyymmdd format -> "yyyymmdd"
 *
 */
char *int_to_date_uf (long int date);

#endif
