/*
 * Hotkeys plugin for Gaim
 *
 * Copyright (C) 2004 Ivan Wong <email@ivanwong.info>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _HOTKEYS_H_
#define _HOTKEYS_H_

#ifdef HAVE_CONFIG_H
#include "hotkeys-config.h"
#endif

#ifdef ENABLE_NLS
#  include <locale.h>
#  include <libintl.h>
#  define _(x) dgettext(GETTEXT_PACKAGE, x)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  include <locale.h>
#  define N_(String) (String)
#  define _(x) (x)
#  define ngettext(Singular, Plural, Number) ((Number == 1) ? (Singular) : (Plural))
#endif

#ifndef GDK_WINDOWING_X11
typedef gint KeyCode;
#endif

typedef struct
{
    const gchar* name;
    const gchar* use_pref;
    const gchar* pref;
    KeyCode code;
    gint mod;
    gboolean enable;
    KeyCode code_;
    gint mod_;
} HotkeyEntry;

enum {
    GAIM_HOTKEY_TOGGLE_BLIST,
    GAIM_HOTKEY_READ_MSG,
    GAIM_HOTKEY_SHOW_PREF,
    GAIM_HOTKEY_SHOW_ACC
};

typedef gboolean (*FilterFunc)(gpointer event_data);
gboolean setup_filter(GdkWindow *root, FilterFunc filter_func);
gint real_event_filter(gpointer event_data,
		       HotkeyEntry* hotkeys,
		       guint num_hotkeys);
gchar* keycode_to_string(KeyCode keycode,
			 GtkWidget* widget);
gboolean parse_keystr(const gchar* keystr,
		      GtkWidget* widget,
		      HotkeyEntry* key);
gboolean grab_key(GdkDisplay* gdisplay,
		  GdkWindow* groot,
		  HotkeyEntry* key);
gboolean free_key(GdkDisplay* gdisplay,
		  GdkWindow* groot,
		  HotkeyEntry* key);
void _free_keys(GdkDisplay* gdisplay,
		GdkWindow* groot,
		HotkeyEntry* hotkeys,
		guint num_hotkeys);
void hacky_active_window(GtkWidget *window);
void release_filter(GdkWindow *root, FilterFunc filter_func);

#endif /* _HOTKEYS_H_ */
