/**
 * @file utils.h Utility functions
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#ifndef _GALAGOD_UTILS_H_
#define _GALAGOD_UTILS_H_

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

void galagod_dbus_send_empty_reply(DBusConnection *dbus_conn,
								   DBusMessage *message);

/**
 * Normalizes the passed name for purposes of using it in D-BUS paths
 * and commands.
 *
 * @param name The name to normalize.
 *
 * @return A pointer to a static buffer containing the normalized name.
 */
const char *galagod_dbus_normalize_name(const char *name);


DBusMessage *galagod_object_not_found_error_new(DBusMessage *message,
												const char *str, ...);

DBusHandlerResult common_object_set_attribute(DBusConnection *dbus_conn,
											  DBusMessage *message,
											  const char *iface,
											  GalagoObject *object,
											  GalagoObject *main_object);
DBusHandlerResult common_object_remove_attribute(DBusConnection *dbus_conn,
												 DBusMessage *message,
												 const char *iface,
												 GalagoObject *object,
												 GalagoObject *main_object);
DBusHandlerResult common_object_get_attribute(DBusConnection *dbus_conn,
											  DBusMessage *message,
											  GalagoObject *object);
DBusHandlerResult common_object_get_attributes(DBusConnection *dbus_conn,
											   DBusMessage *message,
											   GalagoObject *object);

void common_meta_object_merge_attributes(GalagoObject *main_object,
										 GalagoObject *new_object,
										 GList *objects);

#endif /* _GALAGOD_UTILS_H_ */
