namespace Galago.Tests
{
	using System;
	using Galago;
	using Gtk;

	public class Monitor
	{
		public static int Main(string[] args)
		{
			if (args.Length != 1)
			{
				Console.WriteLine("Usage: monitor.exe service-id");
				return 1;
			}

			Application.Init();

			DBus.Connection conn = DBus.Bus.GetSessionBus();

			if (!Galago.Core.InitFeed("monitor"))
			{
				Console.WriteLine("Unable to initialize Galago");

				return 1;
			}

			Service aim = Core.GetService(args[0]);

			if (aim == null)
			{
				Console.WriteLine("Unknown service " + args[0]);
				return 1;
			}

			aim.OnAccountAdded   += new Galago.AddedHandler(AccountAddedCb);
			aim.OnAccountRemoved += new Galago.RemovedHandler(AccountRemovedCb);

			Application.Run();

			Galago.Core.Uninit();

			return 0;
		}

		static void AccountAddedCb(object obj, Galago.AddedArgs args)
		{
			Service service = (Service)obj;
			Account account = args.Object as Account;

			Console.WriteLine("Account " + account.UserName +
							  " added to service " + service.Id);
		}


		static void AccountRemovedCb(object obj, Galago.RemovedArgs args)
		{
			Service service = (Service)obj;
			Account account = args.Object as Account;

			Console.WriteLine("Account " + account.UserName +
							  " removed from service " + service.Id);
		}
	}
}
