<?php

/****************************************************************************
 * Copyright (C) 2005 BRITE NSW Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation (version 2 of the License)
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 ****************************************************************************/

// Uncomment and modify to suit if you want to hardcode a database
//define('GALLIMIMUS_DB', '/random/path/to/gallimimus.db');

require_once 'gallimimus/gallimimus.php';

$DB = OpenDB();
$id = @$_REQUEST['feed'];
if (!ValidFeed($DB, $id))
{
	echo "<p>No valid feed ID supplied.  Exiting.</p>";
	exit;
}

$feed = GetFeed($DB, $id);

$items = FeedItems($DB, $id);
foreach ($items as $i)
{
	$itemdata = array(
		'description' => $i['description'],
		'link' => $i['link'],
		'title' => $i['title'],
		'dc:date' => $i['date']
		);
		$feed->additem($itemdata);
}

/*
 *  When you are done with the definition of the channel items, generate RSS
 *  document.
 */
if($feed->writerss($output))
{
	/*
	 *  If the document was generated successfully, you may not output it.
	 */
	header("Content-Type: text/xml; charset=\"".$feed->outputencoding."\"");
	header("Content-Length: ".strval(strlen($output)));
	echo $output;
}
else
{
/*
 *  If there was an error, output it as well.
 */
	header("Content-Type: text/plain");
	echo ("Error: ".$feed->error);
}
