/***************************************************************************

  exec.h

  Subroutines for the interpreter : executing methods, native methods,
  the NEW operator, the casting operator, etc.

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __GBX_EXEC_H
#define __GBX_EXEC_H

#include "gb_alloc.h"
#include "gb_error.h"
#include "gbx_class.h"
#include "gbx_value.h"
#include "gb_pcode.h"
#include "gbx_stack.h"

#include "gbx_string.h"
#include "gbx_object.h"
#include "gbx_variant.h"
#include "gbx_array.h"

typedef
  void (*EXEC_FUNC)();

typedef
  struct {
    CLASS *class;
    void *object;
    long index;
    //FUNCTION *func;
    CLASS_DESC_METHOD *desc;
    int nparam;
    int nparvar;
    bool drop;
    bool native;
    bool use_stack;
    bool property;
    }
  EXEC_FUNCTION;

typedef
  struct {
    void (*main)();
    int (*loop)();
    void (*wait)();
    int (*message)();
    void (*beep)();
    void (*watch)();
    void (*post)();
    void (*quit)();
    void (*error)();
    }
  EXEC_HOOK;

#ifndef __GBX_EXEC_C

EXTERN STACK_CONTEXT EXEC_current;
EXTERN PCODE EXEC_code;
EXTERN VALUE *SP;
EXTERN VALUE TEMP;
EXTERN VALUE RET;
EXTERN EXEC_FUNCTION EXEC;

/*
EXTERN boolean EXEC_stop_next;
EXTERN boolean EXEC_stop_next_line;
EXTERN FUNCTION *EXEC_stop_function;
EXTERN PCODE *EXEC_begin_line;
EXTERN PCODE *EXEC_end_line;
*/

EXTERN bool EXEC_debug;
EXTERN bool EXEC_arch;
EXTERN bool EXEC_fifo;

EXTERN EXEC_HOOK EXEC_Hook;

EXTERN bool EXEC_enum_stop;
EXTERN void *EXEC_enum_data;

EXTERN bool EXEC_big_endian;

/*EXTERN long EXEC_const[];*/

#endif

/* Pointeur de rfrence des variables locales */
#define BP EXEC_current.bp
/* Classe en cours */
#define CP EXEC_current.cp
/* Objet en cours */
#define OP EXEC_current.op
/* Pointeur de rfrence des paramtres */
/*#define PP EXEC_current.pp*/
/* Sauvegarde du pointeur de pile pour un TRY */
#define EP EXEC_current.ep
/* fonction en cours */
#define FP EXEC_current.fp
/* Pointeur de programme */
#define PC EXEC_current.pc
/* Emplacement o aller en cas d'erreur */
#define EC EXEC_current.ec
/* Emplacement de sauvegarde pour TRY */
#define ET EXEC_current.et
/* Valeur de retour d'une fonction */
#define RP (&RET)

#define HOOK(func) (!EXEC_Hook.func) ? 0 : (*EXEC_Hook.func)
#define HOOK_DEFAULT(func, def) (*((!EXEC_Hook.func) ? def : EXEC_Hook.func))

#define GET_NPARAM(var)         short var = *PC & 0x3F
#define GET_PARAM(var, nparam)  VALUE *var = &SP[-nparam]

/*
#define EXEC_output_on_file(file) (EXEC_Output = (file), EXEC_OutputString = NULL)
#define EXEC_output_on_string(str) (EXEC_Output = NULL, EXEC_OutputString = (str))
*/


#define RELEASE_STRING(_value)
  /*
  if (value->type == T_STRING)
    STRING_unref(&value->_string.addr);
  else if ((value->type == T_VARIANT) && (value->_variant.vtype == T_STRING))
    STRING_unref((char **)value->_variant.value);
  */

#define PUSH() (BORROW(SP), SP++)
#define POP()  (SP--, RELEASE(SP))

PUBLIC void EXEC_init(void);

PUBLIC void EXEC_enter(void);
PUBLIC void EXEC_leave(bool);
PUBLIC void EXEC_loop(void);

PUBLIC void EXEC_object(VALUE *SP, CLASS **class, OBJECT **object, boolean *defined);
PUBLIC void *EXEC_auto_create(CLASS *class);

PUBLIC bool EXEC_call_native(void (*exec)(), void *object, TYPE type, VALUE *param);
PUBLIC void EXEC_native();
PUBLIC void EXEC_function_real(bool keep_ret_value);

#define EXEC_function() EXEC_function_real(FALSE)
#define EXEC_function_keep() EXEC_function_real(TRUE)

PUBLIC void EXEC_public(CLASS *class, void *object, const char *name, int nparam);

PUBLIC boolean EXEC_spec(int spec, CLASS *class, void *object, int nparam, boolean drop);
#define EXEC_special(_spec, _class, _object, _nparam, _drop) EXEC_spec(_spec, _class, _object, _nparam, _drop)
/*#define EXEC_special_use_stack(_spec, _class, _object, _nparam, _drop) EXEC_spec(_spec, _class, _object, _nparam, _drop, TRUE)*/

PUBLIC void EXEC_special_inheritance(int special, CLASS *class, OBJECT *object, int nparam, boolean drop);

PUBLIC void EXEC_nop(void);
PUBLIC void EXEC_ILLEGAL(void);

PUBLIC void EXEC_push_unknown(void);
PUBLIC void EXEC_push_array(void);
PUBLIC void EXEC_push_special(void);

PUBLIC void EXEC_pop_unknown(void);
PUBLIC void EXEC_pop_array(void);

PUBLIC void EXEC_enum_first(PCODE code);
PUBLIC bool EXEC_enum_next(PCODE code);

PUBLIC void EXEC_new(void);
PUBLIC void EXEC_class(void);

PUBLIC void BORROW(VALUE *val);
PUBLIC void UNBORROW(VALUE *val);
PUBLIC void RELEASE(VALUE *val);

PUBLIC void EXEC_release_return_value(void);
PUBLIC void EXEC_quit(void);

#endif /* */
