/***************************************************************************

  eval_trans.h

  Code translation

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __EVAL_TRANS_H
#define __EVAL_TRANS_H

#include "gb_type_common.h"
#include "gb_reserved.h"
#include "eval_read.h"
#include "gb_limit.h"
#include "../../exec/gbx_class.h"

typedef
  struct {
    TYPE type;
    long index;
    PATTERN *optional;
    long value;
    }
  TRANS_PARAM;  /* must be the same as PARAM in class.h */

typedef
  struct {
    short type;
    long ival;
    double dval;
    }
  TRANS_NUMBER;

typedef
  struct {
    TYPE type;
    short ndim;
    long dim[MAX_ARRAY_DIM];
    }
  TRANS_ARRAY;

typedef
  struct {
    long index;               /* index dans la table des symboles */
    TYPE type;                /* type de donnes */
    long value;               /* valeur associe */
    boolean is_new;           /* s'il faut instancier un objet */
    boolean is_integer;       /* si la valeur de la constante est entire */
    TRANS_ARRAY array;        /* dimensions du tableau si dclaration */
    }
  TRANS_DECL;

typedef
  struct {
    long index;
    TYPE type;
    int nparam;
    TRANS_PARAM param[MAX_PARAM_FUNC];
    PATTERN *start;
    long line;
    }
  PACKED
  TRANS_FUNC;

typedef
  struct {
    long index;
    TYPE type;
    int nparam;
    TRANS_PARAM param[MAX_PARAM_FUNC];
    }
  PACKED
  TRANS_EVENT;

typedef
  struct {
    long index;
    TYPE type;
    int nparam;
    TRANS_PARAM param[MAX_PARAM_FUNC];
    long library;
    }
  PACKED
  TRANS_EXTERN;

typedef
  struct {
    long type;
    long value;
    int state;
    short *pos;
    short *pos_break;
    short *pos_continue;
    short local;
    short id;
    }
  PACKED
  TRANS_CTRL;

typedef
  struct {
    long index;
    short pos;
    short ctrl_id;
    long line;
    }
  PACKED
  TRANS_GOTO;

typedef
  struct {
    long pos;
    short ctrl_id;
    }
  PACKED
  TRANS_LABEL;

typedef
  struct {
    RESERVED_ID id;
    void (*func)();
    }
  TRANS_STATEMENT;

/*
enum {
  TT_NOTHING = 0,
  TT_DO_NOT_CHECK_AS = 1,
  TT_CAN_SQUARE = 2,
  TT_CAN_ARRAY = 4,
  TT_CAN_NEW = 8
  };
*/

/*
PUBLIC void TRANS_reset(void);
PUBLIC boolean TRANS_newline(void);
PUBLIC boolean TRANS_type(int flag, TRANS_DECL *result);
PUBLIC boolean TRANS_check_declaration(void);
PUBLIC void TRANS_get_constant_value(TRANS_DECL *decl, PATTERN value);

PUBLIC void TRANS_want(int reserved);
PUBLIC boolean TRANS_is(int reserved);
PUBLIC void TRANS_ignore(int reserved);
*/

PUBLIC boolean TRANS_get_number(long index, TRANS_NUMBER *result);

/* eval_trans_expr.c */

PUBLIC void EVAL_translate(void);
PUBLIC void TRANS_operation(short op, short nparam, boolean output);

/* eval_trans_tree.c */

#define RS_UNARY (-1)

PUBLIC void TRANS_tree(void);
/*PUBLIC boolean TRANS_is_statement(TRANS_TREE *tree);*/

#endif

