/***************************************************************************

  main.c

  A component example

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __MAIN_C

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

/* We include the headers of each class. Our example has only one class. */

#include "CExample.h"


/* We include the main header that contain mandatory includes, and
   hook declarations.
*/

#include "main.h"


/* The dialog between the interpreter and the component is based on special symbols
   exported by the share library of the component.

   These symbols are : GB, GB_CLASS, GB_INIT, GB_EXIT and GB_INFO.

   If your component is written in C++, you must enclose the following code
   between an extern "C" declaration so that the compiler does not encode the
   symbols in the C++ way.
*/

#ifdef __cplusplus
extern "C" {
#endif

/* The following structure will be automatically initialized by the Gambas component
   loader so that you have access to the interpreter.

   To get a documentation of the GB interface functions, see gambas.h
*/

GB_INTERFACE GB;


/* The following array must contain the description of each class included in the
   component. The last element of the array must be a NULL pointer.
*/

GB_DESC *GB_CLASSES[] =
{
  CExampleDesc,
  NULL
};


/* The following function is called when the component is loaded. */

int GB_INIT(void)
{
  /* You can initialize interpreters hooks.
     The following hook is used to interpret the command line.
  */

  GB.Hook(GB_HOOK_MAIN, (void *)hook_main);

  /* The following hooks are only useful for components that implements an event
     loop, like the QT component. See the sources of this component for more details.
  */

  #ifndef THIS_IS_JUST_AN_EXAMPLE
  GB.Hook(GB_HOOK_LOOP, (void *)hook_loop);
  GB.Hook(GB_HOOK_WAIT, (void *)hook_wait);
  GB.Hook(GB_HOOK_WATCH, (void *)hook_watch);
  GB.Hook(GB_HOOK_POST, (void *)hook_post);
  #endif

  /* If this function does not return zero, the component will never be unloaded
     by Gambas. This is very useful if your component contains functions registered
     with atexit().
  */

  return 0;
}


/* The following function is called when the component is unloaded */

void GB_EXIT()
{
}


/* The functions that must have a C linkage end here. */

#ifdef _cpluscplus
}
#endif


/* We now implement the hook functions. */

/* The hook MAIN is called to analyze the command line arguments.

   The first argument is a pointer to the argc argument of main(), the second
   argument is the argv argument of main().

   If your component interprets some of the command-line arguments, it must "eat"
   them by modifying both the argv contents and the value pointed by argc : some
   other components can have a main hook, and they must not see the arguments
   that were intended for you.
*/

static void hook_main(int *argc, char **argv)
{
  int i;

  /* This will print the command line when the component is loaded. */

  printf("gb.example: argc = %d\n", *argc);
  for (i = 0; i < *argc; i++)
    printf("gb.example: argv[%d] = \"%s\"\n", i, argv[i]);
}


/* The hook LOOP is called after the interpreter has ran the Main() function of
   the Gambas program.

   This function must return when the program ends.

   If no component has declared a LOOP hook, the program ends immediately after
   the Main() function has terminated.
*/

#ifndef THIS_IS_JUST_AN_EXAMPLE
static int hook_loop(void)
{
 /* Calls the event loop... */
}
#endif


/* The hook WAIT is called by interpreter to implement the WAIT instruction.

   The duration argument is a delay in milliseconds.

   If this function returns before the delay elapses, the interpreter will call
   it again and again until the delay specified by the user in the WAIT instruction
   elapses.
*/

#ifndef THIS_IS_JUST_AN_EXAMPLE
static void hook_wait(long duration)
{
  /* Waits up to duration milliseconds, and calls the event loop meanwhile. */
}
#endif


/* the hook WATCH is called when the interpreter must watch a specified file
   descriptor.

   The fd argument is the file descriptor.

   The type argument can be one the following constant:
   - GB_WATCH_NONE to stop watching the file descriptor.
   - GB_WATCH_READ to watch the file descriptor for reading.
   - GB_WATCH_WRITE to watch the file descriptor for writing.
   - GB_WATCH_READ_WRITE to watch the file descriptor for both reading and writing.

   The callback argument is a function that must be called by the event loop
   when something happens on the file descriptor.

   The param argument will be pass to the callback as it.

   The callback function has the GB_WATCH_CALLBACK type, that means it has the
   following prototype:

   void callback(int fd, int type, long param);

   The callback arguments are the arguments passed to the hook.
*/

#ifndef THIS_IS_JUST_AN_EXAMPLE
static void hook_watch(int fd, int type, void *callback, long param)
{
  /* Starts or stops a watch operation. */
}
#endif


/* The POST hook is called by the interpreter when it has posted a "post routine",
   i.e. a routine that must be called by the event loop as soon as possible but not
   during the current loop.

   For example, the SIGCHLD signal handler installed by the interpreter uses a
   post routine to raise the Process.Kill event because you cannot do such a thing
   into a signal handler.

   To run the posted routines, you just have to call the Gambas interface method
   GB.CheckPost().
*/

#ifndef THIS_IS_JUST_AN_EXAMPLE
static void hook_post(void)
{
 /* You know that you must manage posted routines as soon as possible. */
}
#endif


