/***************************************************************************

  CContainer.h

  The Container class

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __CCONTAINER_H
#define __CCONTAINER_H

#include <qobject.h>
#if QT_VERSION >= 0x030200
#include <qobjectlist.h>
#else
#include <qobjcoll.h>
#endif
#include <qframe.h>

#include "gambas.h"

#include "CConst.h"
#include "CWidget.h"

typedef
  struct {
    unsigned char mode;
    unsigned char spacing;
    unsigned char padding;
    unsigned autoresize:1;
    unsigned locked:1;
    unsigned _reserved:6;
    }
  CARRANGEMENT;

#ifndef __CCONTAINER_CPP

extern GB_DESC CContainerDesc[];
extern GB_DESC CChildrenDesc[];

#else

typedef
  struct {
    CWIDGET widget;
    QWidget *container;
    unsigned char mode;
    unsigned char spacing;
    unsigned char padding;
    unsigned autoresize:1;
    unsigned locked:1;
    unsigned _reserved:6;
    }
  CCONTAINER_ARRANGEMENT;
  
#define WIDGET QWIDGET(_object)
#define THIS ((CCONTAINER *)_object)
#define THIS_CONTAINER (THIS->container)
#define THIS_ARRANGEMENT (((CCONTAINER_ARRANGEMENT *)_object))

//#define CCONTAINER_PROPERTIES CWIDGET_PROPERTIES ",Arrangement"

#endif

DECLARE_PROPERTY(CCONTAINER_arrangement);
DECLARE_PROPERTY(CCONTAINER_auto_resize);
DECLARE_PROPERTY(CCONTAINER_padding);
DECLARE_PROPERTY(CCONTAINER_spacing);

void CCONTAINER_arrange(QFrame *w);

class MyContainer : public QFrame
{
  Q_OBJECT

public:

  MyContainer(QWidget *);

protected:

  void frameChanged();
  void resizeEvent(QResizeEvent *);
  void childEvent(QChildEvent *);
  bool eventFilter(QObject *, QEvent *);
};

#define CARRANGEMENT_PROPERTIES "Arrangement,AutoResize,Spacing,Padding"

#endif
