/***************************************************************************

  CScreen.cpp

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __CSCREEN_CPP



#include <qapplication.h>
#include <qtooltip.h>

#include "gambas.h"
#include "CPicture.h"
#include "CWidget.h"
#include "CWindow.h"
#include "CFont.h"
#include "CScreen.h"

static int screen_busy = 0;


BEGIN_PROPERTY(CSCREEN_width)

  GB.ReturnInteger(qApp->desktop()->width());

END_PROPERTY


BEGIN_PROPERTY(CSCREEN_height)

  GB.ReturnInteger(qApp->desktop()->height());

END_PROPERTY


BEGIN_PROPERTY(CSCREEN_resolution)

  GB.ReturnInteger(QPaintDevice::x11AppDpiY());

END_PROPERTY


BEGIN_PROPERTY(CSCREEN_font)

  if (READ_PROPERTY)
    GB.ReturnObject(CFONT_create(qApp->font(), CFONT_APPLICATION));
  else
    qApp->setFont(*((CFONT *)VPROP(GB_OBJECT))->font);

END_PROPERTY


BEGIN_PROPERTY(CSCREEN_active_window)

  GB.ReturnObject(CWidget::get(qApp->activeWindow()));

END_PROPERTY


BEGIN_PROPERTY(CSCREEN_busy)

  long busy;

  if (READ_PROPERTY)
    GB.ReturnInteger(screen_busy);
  else
  {
    busy = VPROP(GB_INTEGER);

    if (screen_busy == 0 && busy != 0)
      qApp->setOverrideCursor(Qt::waitCursor);
    else if (screen_busy > 0 && busy == 0)
      qApp->restoreOverrideCursor();

    screen_busy = busy;
  }

END_PROPERTY


BEGIN_PROPERTY(CSCREEN_charset)

  GB.ReturnConstZeroString("UTF-8");

END_PROPERTY


BEGIN_METHOD_VOID(CSCREEN_grab)

  GB.ReturnObject(CPICTURE_grab(0));

END_METHOD


BEGIN_PROPERTY(CAPP_tooltip_enabled)

  if (READ_PROPERTY)
    GB.ReturnBoolean(QToolTip::isGloballyEnabled());
  else
    QToolTip::setGloballyEnabled(VPROP(GB_BOOLEAN));

END_PROPERTY


BEGIN_PROPERTY(CAPP_tooltip_font)

  if (READ_PROPERTY)
    GB.ReturnObject(CFONT_create(QToolTip::font()));
  else
    QToolTip::setFont(*((CFONT *)VPROP(GB_OBJECT))->font);
  
END_PROPERTY


BEGIN_PROPERTY(CAPP_main_window)

  GB.ReturnObject(CWINDOW_Main);

END_PROPERTY




GB_DESC CDesktopDesc[] =
{
  GB_DECLARE("Desktop", 0), GB_VIRTUAL_CLASS(),

  GB_STATIC_PROPERTY_READ("W", "i", CSCREEN_width),
  GB_STATIC_PROPERTY_READ("H", "i", CSCREEN_height),
  GB_STATIC_PROPERTY_READ("Width", "i", CSCREEN_width),
  GB_STATIC_PROPERTY_READ("Height", "i", CSCREEN_height),
  GB_STATIC_PROPERTY_READ("Charset", "s", CSCREEN_charset),
  GB_STATIC_PROPERTY_READ("Resolution", "i", CSCREEN_resolution),

  GB_STATIC_METHOD("Grab", "Picture", CSCREEN_grab, NULL),

  GB_END_DECLARE
};

GB_DESC CApplicationTooltipDesc[] =
{
  GB_DECLARE(".ApplicationTooltip", 0), GB_VIRTUAL_CLASS(),

  GB_STATIC_PROPERTY("Enabled", "b", CAPP_tooltip_enabled),
  GB_STATIC_PROPERTY("Font", "Font", CAPP_tooltip_font),

  GB_END_DECLARE
};



GB_DESC CApplicationDesc[] =
{
  GB_DECLARE("Application", 0), GB_VIRTUAL_CLASS(),

  GB_STATIC_PROPERTY("Font", "Font", CSCREEN_font),
  GB_STATIC_PROPERTY_READ("ActiveWindow", "o", CSCREEN_active_window),
  GB_STATIC_PROPERTY_READ("MainWindow", "o", CAPP_main_window),
  GB_STATIC_PROPERTY("Busy", "i", CSCREEN_busy),
  GB_STATIC_PROPERTY_SELF("ToolTip", ".ApplicationTooltip"),

  GB_END_DECLARE
};


