#############################################################################
##
#W  construc.gd           GAP 4 package `ctbllib'               Thomas Breuer
##
#H  @(#)$Id: construc.gd,v 1.14 2004/03/23 10:14:25 gap Exp $
##
#Y  Copyright (C)  2002,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  1. Character Tables of Groups of Structure $M.G.A$
##  2. Character Tables of Groups of Structure $G.S_3$
##  3. Character Tables of Groups of Structure $G.2^2$
##  4. Character Tables of Groups of Structure $2^2.G$
##  5. Brauer Tables of Extensions by $p$-regular Automorphisms
##  6. Construction Functions used in the Character Table Library
##  7. Character Tables of Coprime Central Extensions
##  8. Miscellaneous
##
Revision.( "ctbllib/gap4/construc_gd" ) :=
    "@(#)$Id: construc.gd,v 1.14 2004/03/23 10:14:25 gap Exp $";


#############################################################################
#1
##  The functions in this chapter deal with the construction of character
##  tables from other character tables.  So they fit to the functions in
##  Section~"ref:Constructing Character Tables from Others" in the {\GAP}
##  Reference Manual.
##  But since they are used in situations that are typical for the {\GAP}
##  Character Table Library, they are described here.
##
##  An important ingredient of the constructions is the description of the
##  action of a group automorphism on the classes by a permutation.
##  In practice, these permutations are usually chosen from the group of
##  table automorphisms of the character table in question
##  (see~"ref:AutomorphismsOfTable" in the {\GAP} Reference Manual).
##
##  Section~"Character Tables of Groups of Structure MGA" deals with
##  groups of structure $M\.G\.A$, where the upwards extension $G\.A$ acts
##  suitably on the central extension $M\.G$.
##  Section~"Character Tables of Groups of Structure GS3" deals with
##  groups that have a factor group of type $S_3$.
#T  The sections~"Character Tables of Groups of Structure GV4"
#T  and~"Character Tables of Groups of Structure V4G" deal with the
#T  character tables of upwards and downwards extensions of a group by a
#T  Klein four group.
#T  Section~"Brauer Tables of Extensions by p-regular Automorphisms"
#T  describes the construction of certain Brauer tables.
##  Section~"Character Tables of Coprime Central Extensions" deals with
##  special cases of the construction of character tables of central
##  extensions from known character tables of suitable factor groups.
##  Section~"Construction Functions used in the Character Table Library"
##  documents the functions used to encode certain tables in the {\GAP}
##  Character Table Library.
##
##  Examples can be found in~\cite{Auto}.
##


#############################################################################
##
##  1. Character Tables of Groups of Structure $M.G.A$
##


#############################################################################
##
#F  PossibleCharacterTablesOfTypeMGA( <tblMG>, <tblG>, <tblGA>, <aut>,
#F      <identifier> )
##
##  Let $H$ be a group with normal subgroups $N$ and $M$ such that
##  $H/N$ is cyclic, $M \leq N$ holds,
##  and such that each irreducible character of $N$
##  that does not contain $M$ in its kernel induces irreducibly to $H$.
##  (This is satisfied for example if $N$ has prime index in $H$
##  and $M$ is a group of prime order that is central in $N$ but not in $H$.)
##  Let $G = N/M$ and $A = H/N$, so $H$ has the structure $M\.G\.A$.
##
##  Let <tblMG>, <tblG>, <tblGA> be the ordinary character tables of the
##  groups $M\.G$, $G$, and $G\.A$, respectively,
##  and <aut> the permutation of classes of <tblMG> induced by the action
##  of $H$ on $M\.G$.
##  Furthermore, let the class fusions from <tblMG> to <tblG> and from <tblG>
##  to <tblGA> be stored on <tblMG> and <tblG>, respectively
##  (see~"ref:StoreFusion" in the {\GAP} Reference Manual).
##
##  `PossibleCharacterTablesOfTypeMGA' returns a list of records describing
##  all possible character tables for groups $H$ that are compatible with the
##  arguments.
##  Note that in general there may be several possible groups $H$,
##  and it may also be that ``character tables'' are constructed for which no
##  group exists.
##  Each of the records in the result has the following components.
##  \beginitems
##  `table' &
##      the ordinary character table of a possible table for $H$, and
##
##  `MGfusMGA' &
##      the fusion map from <tblMG> into the table stored in `table'.
##  \enditems
##  The possible tables differ w.r.t. some power maps, and perhaps element
##  orders and table automorphisms;
##  in particular, the `MGfusMGA' component is the same in all records.
##
##  The returned tables have the `Identifier' value <identifier>.
##  The classes of these tables are sorted as follows.
##  First come the classes contained in $M\.G$, sorted compatibly with the
##  classes in <tblMG>, then the classes in $H \setminus M\.G$ follow,
##  in the same ordering as the classes of $G\.A \setminus G$.
##
DeclareGlobalFunction( "PossibleCharacterTablesOfTypeMGA" );


#############################################################################
##
#F  PossibleActionsForTypeMGA( <tblMG>, <tblG>, <tblGA> )
##
##  Let the arguments be as described for `PossibleCharacterTablesOfTypeMGA'
##  (see~"PossibleCharacterTablesOfTypeMGA").
##  `PossibleActionsForTypeMGA' returns the set of those table automorphisms
##  (see~"ref:AutomorphismsOfTable" in the {\GAP} Reference Manual)
##  of <tblMG> that can be induced by the action of $H$ on $M\.G$.
##
##  Information about the progress is reported if the info level of
##  `InfoCharacterTable' is at least $1$
##  (see~"ref:SetInfoLevel" in the {\GAP} Reference Manual).
##
DeclareGlobalFunction( "PossibleActionsForTypeMGA" );


#############################################################################
##
##  2. Character Tables of Groups of Structure $G.S_3$
##


#############################################################################
##
#F  CharacterTableOfTypeGS3( <tbl>, <tbl2>, <tbl3>, <aut>, <identifier> )
#F  CharacterTableOfTypeGS3( <modtbl>, <modtbl2>, <modtbl3>, <ordtbls3>,
#F                           <identifier> )
##
##  Let $H$ be a group with a normal subgroup $G$ such that $H/G \cong S_3$,
##  the symmetric group on three points,
##  and let $G\.2$ and $G\.3$ be preimages of subgroups of order $2$ and $3$,
##  respectively, under the natural projection onto this factor group.
##
##  In the first form, let <tbl>, <tbl2>, <tbl3> be the ordinary character
##  tables of the groups $G$, $G\.2$, and $G\.3$, respectively,
##  and <aut> the permutation of classes of <tbl3> induced by the action
##  of $H$ on $G\.3$.
##  Furthermore assume that the class fusions from <tbl> to <tbl2> and <tbl3>
##  are stored on <tbl>
##  (see~"ref:StoreFusion" in the {\GAP} Reference Manual).
##
##  In the second form, let <modtbl>, <modtbl2>, <modtbl3> be the $p$-modular
##  character tables of the groups $G$, $G\.2$, and $G\.3$, respectively,
##  and <ordtbls3> the ordinary character table of $H$.
##
##  `CharacterTableOfTypeGS3' returns a record with the following components.
##  \beginitems
##  `table' &
##      the ordinary or $p$-modular character table of $H$, respectively,
##
##  `tbl2fustbls3' &
##      the fusion map from <tbl2> into the table of $H$, and
##
##  `tbl3fustbls3' &
##      the fusion map from <tbl3> into the table of $H$.
##  \enditems
##
##  The returned table of $H$ has the `Identifier' value <identifier>.
##  The classes of the table of $H$ are sorted as follows.
##  First come the classes contained in $G\.3$, sorted compatibly with the
##  classes in <tbl3>, then the classes in $H \setminus G\.3$ follow,
##  in the same ordering as the classes of $G\.2 \setminus G$.
##
#T  In fact the code is applicable in the more general case that $H/G$ is a
#T  Frobenius group $F = K C$ with abelian kernel $K$ and cyclic complement
#T  $C$ of prime order, see~\cite{Auto}.
#T  Besides $F = S_3$, e.g., the case $F = A_4$ is interesting.
##
DeclareGlobalFunction( "CharacterTableOfTypeGS3" );


#############################################################################
##
#F  PossibleActionsForTypeGS3( <tbl>, <tbl2>, <tbl3> )
##
##  Let the arguments be as described for `CharacterTableOfTypeGS3'
##  (see~"CharacterTableOfTypeGS3").
##  `PossibleActionsForTypeGS3' returns the set of those table automorphisms
##  (see~"ref:AutomorphismsOfTable" in the {\GAP} Reference Manual)
##  of <tbl3> that can be induced by the action of $H$ on the classes of
##  <tbl3>.
##
##  Information about the progress is reported if the info level of
##  `InfoCharacterTable' is at least $1$
##  (see~"ref:InfoCharacterTable" in the {\GAP} Reference Manual).
##
DeclareGlobalFunction( "PossibleActionsForTypeGS3" );


#############################################################################
##
##  3. Character Tables of Groups of Structure $G.2^2$
#4
##  The following functions are thought for constructing the possible
##  ordinary character tables of a group of structure $G\.2^2$ from the known
##  tables of the three normal subgroups of type $G\.2$.
##


#############################################################################
##
#F  PossibleCharacterTablesOfTypeGV4( <tblG>, <tblsG2>, <acts>, <identifier> )
##
##  Let <tblG> be the ordinary character table of a group $G$, say,
##  and let <tblsG2> be a list of three character tables of groups $G\.2_1$,
##  $G\.2_2$, $G\.2_3$, say, which contain $G$ as a subgroup of index $2$.
##  Let <acts> be a list of three permutations describing the action of a
##  group $H$, say, that contains $G\.2_1$, $G\.2_2$, $G\.2_3$ as index $2$
##  subgroups which intersect in the index $4$ subgroup $G$,
##  on the conjugacy classes of the corresponding tables in <tblsG2>.
##  Further it is assumed that the class fusions from <tblG> into the tables
##  in <tblsG2> are stored on <tblG>.
##
##  `PossibleCharacterTablesOfTypeGV4' returns a list of records describing
##  all possible character tables for groups $H$ that are compatible with the
##  arguments; note that in general there may be several such groups.
##  Each of the records has the following components.
##  \beginitems
##  `table' &
##      the ordinary character table of a possible table for $H$, and
##
##  `G2fusGV4' &
##      the list of fusion maps from the tables in <tblsG2> into the table.
##  \enditems
##  The possible tables differ w.r.t. the irreducible characters and perhaps
##  the table automorphisms;
##  in particular, the `G2fusGV4' component is the same in all records.
##
##  The returned tables have the `Identifier' value <identifier>.
##  The classes of these tables are sorted as follows.
##  First come the classes contained in $G$, sorted compatibly with the
##  classes in <tblG>, then the outer classes in the tables in <tblsG2>
##  follow, in the same ordering as in these tables.
##
DeclareGlobalFunction( "PossibleCharacterTablesOfTypeGV4" );


#############################################################################
##
#F  PossibleActionsForTypeGV4( <tblG>, <tblsG2> )
##
##  Let the arguments be as described for `PossibleCharacterTablesOfTypeGV4'
##  (see~"PossibleCharacterTablesOfTypeGV4").
##  `PossibleActionsForTypeGV4' returns the list of those triples
##  $[ \pi_1, \pi_2, \pi_3 ]$ of permutations for which a group $H$ may exist
##  that contains $G\.2_1$, $G\.2_2$, $G\.2_3$ as index $2$ subgroups
##  which intersect in the index $4$ subgroup $G$.
##
##  Information about the progress is reported if the level of
##  `InfoCharacterTable' is at least $1$
##  (see~"ref:SetInfoLevel" in the {\GAP} Reference Manual).
##
DeclareGlobalFunction( "PossibleActionsForTypeGV4" );


#############################################################################
##
##  4. Character Tables of Groups of Structure $2^2.G$
#5
##  The following function is thought for constructing the possible ordinary
##  character tables of a group of structure $2^2\.G$ from the known tables
##  of the three factor groups modulo the normal order two subgroups in the
##  Klein four group.
##


#############################################################################
##
#F  PossibleCharacterTablesOfTypeV4G( <tblG>, <tbls2G>, <identifier> )
#F  PossibleCharacterTablesOfTypeV4G( <tblG>, <tbl2G>, <aut>, <identifier> )
##
##  Let $H$ be a group with a central subgroup $N$ of type $2^2$,
##  and let $Z_1$, $Z_2$, $Z_3$ be the order $2$ subgroups of $N$.
##
##  In the first form, let <tblG> be the ordinary character table of $H/N$,
##  and <tbls2G> be a list of length three, the entries being the ordinary
##  character tables of the groups $H/Z_i$.
##  In the second form, let <tbl2G> be the ordinary character table of
##  $H/Z_i$ and <aut> be a permutation;
##  here it is assumed that the groups $Z_i$ are permuted under an
##  automorphism $\sigma$ of order $3$ of $H$, and that $\sigma$ induces the
##  permutation <aut> on the classes of <tblG>.
##
##  Let the class fusions from <tblG> into the tables in <tbls2G> or <tbl2G>,
##  respectively, be stored on <tblG>.
##
##  `PossibleCharacterTablesOfTypeV4G' returns the list of all possible
##  character tables for $H$ in this situation.
##  The returned tables have the `Identifier' value <identifier>.
#T which criteria are used?
##
DeclareGlobalFunction( "PossibleCharacterTablesOfTypeV4G" );


#############################################################################
##
##  5. Brauer Tables of Extensions by $p$-regular Automorphisms
#6
##  As for the construction of Brauer character tables from known tables,
##  the functions `PossibleCharacterTablesOfTypeMGA'
##  (see~"PossibleCharacterTablesOfTypeMGA") and `CharacterTableOfTypeGS3'
##  (see~"CharacterTableOfTypeGS3") work for both ordinary and Brauer tables.
##  The following function is designed specially for Brauer tables.
##


#############################################################################
##
#F  BrauerTableOfExtensionBySingularAutomorphism( <modtbl>, <ordexttbl> )
##
##  Let <modtbl> be a $p$-modular Brauer table of the group $G$, say,
##  and <ordexttbl> the ordinary character table of an extension of $G$
##  by an automorphism of order $p$.
##  Further let the class fusion from the ordinary table of <modtbl> into
##  <ordexttbl> be stored.
##  Then `BrauerTableOfExtensionBySingularAutomorphism' returns the
##  $p$-modular Brauer table of <ordexttbl>.
##
DeclareGlobalFunction( "BrauerTableOfExtensionBySingularAutomorphism" );


#############################################################################
##
##  6. Construction Functions used in the Character Table Library
#7
##  The following functions are used in the {\GAP} Character Table Library,
##  for encoding table constructions via the mechanism that is based on the
##  attribute `ConstructionInfoCharacterTable'
##  (see~"ConstructionInfoCharacterTable").
##  All construction functions take as their first argument a record that
##  describes the table to be constructed, and the function adds only those
##  components that are not yet contained in this record.
##


#############################################################################
##
#F  ConstructMGA( <tbl>, <subname>, <factname>, <plan>, <perm> )
##
##  `ConstructMGA' constructs the ordinary character table <tbl> of a group
##  $m\.G\.a$ where the automorphism $a$ (a group of prime order) of $m\.G$
##  acts notrivially on the central subgroup $m$ of $m\.G$.
##  <subname> is the name of the subgroup $m\.G$ which is a (not necessarily
##  cyclic) central extension of the (not necessarily simple) group $G$,
##  <factname> is the name of the factor group $G\.a$.
##  Then the faithful characters of <tbl> are induced characters of $m\.G$.
##
##  <plan> is a list, each entry being a list containing positions of
##  characters of $m\.G$ that form an orbit under the action of $a$
##  (so the induction of characters is simulated).
##
##  <perm> is the permutation that must be applied to the list of characters
##  that is obtained on appending the faithful characters to the
##  inflated characters of the factor group.
##  A nonidentity permutation occurs for example for groups of structure
##  $12\.G\.2$ that are encoded via the subgroup $12\.G$ and the factor group
##  $6\.G\.2$, where the faithful characters of $4\.G\.2$ shall precede those
##  of $6\.G\.2$.
##
##  Examples where `ConstructMGA' is used to encode library tables are the
##  tables of $3\.F_{3+}\.2$ (subgroup $3\.F_{3+}$, factor group $F_{3+}\.2$)
##  and $12_1\.U_4(3)\.2_2$ (subgroup $12_1\.U_4(3)$, factor group
##  $6_1\.U_4(3)\.2_2$).
##
DeclareGlobalFunction( "ConstructMGA" );

DeclareSynonym( "ConstructMixed", ConstructMGA );


#############################################################################
##
#F  ConstructMGAInfo( <tblmGa>, <tblmG>, <tblGa> )
##
##  Let <tblmGa> be the ordinary character table of a group of structure
##  $m\.G\.a$ where the factor group of prime order $a$ acts nontrivially on
##  the normal subgroup of order $m$ that is central in $m\.G$,
##  <tblmG> the character table of $m\.G$, and <tblGa> the character table of
##  the factor group $G\.a$.
##
##  `ConstructMGAInfo' returns the list that is to be stored in the library
##  version of <tblmGa>: the first entry is the string `"ConstructMGA"',
##  the remaining four entries are the last four arguments for the call to
##  `ConstructMGA' (see~"ConstructMGA").
##
DeclareGlobalFunction( "ConstructMGAInfo" );


#############################################################################
##
#F  ConstructGS3( <tbls3>, <tbl2>, <tbl3>, <ind2>, <ind3>, <ext>, <perm> )
#F  ConstructGS3Info( <tbl2>, <tbl3>, <tbls3> )
##
##  `ConstructGS3' constructs the irreducibles of an ordinary character table
##  <tbls3> of type $G\.S_3$ from the tables with names <tbl2> and <tbl3>,
##  which correspond to the groups $G\.2$ and $G\.3$, respectively.
##  <ind2> is a list of numbers referring to irreducibles of <tbl2>.
##  <ind3> is a list of pairs, each referring to irreducibles of <tbl3>.
##  <ext>  is a list of pairs, each referring to one irreducible of <tbl2>
##                             and one of <tbl3>.
##  <perm> is a permutation that must be applied to the irreducibles
##  after the construction.
##
##  `ConstructGS3Info' returns a record with the components `ind2', `ind3',
##  `ext', `perm', and `list', as are needed for `ConstructGS3'.
#T better return just the `list' component?
##
DeclareGlobalFunction( "ConstructGS3" );

DeclareGlobalFunction( "ConstructGS3Info" );


#############################################################################
##
#F  ConstructV4G( <tbl>, <facttbl>, <aut>[, <ker>] )
##
##  Let <tbl> be the character table of a group of type $2^2\.G$
##  where an outer automorphism of order 3 permutes the three involutions
##  in the central $2^2$.
##  Let <aut> be the permutation of classes of <tbl> induced by that
##  automorphism, and <facttbl> the name of the character table
##  of the factor group $2\.G$.
##  Then `ConstructV4G' constructs the irreducible characters of <tbl> from
##  that information.
##
##  The optional argument <ker> is an integer denoting the position of the
##  nontrivial class of the table of $2\.G$ that lies in the kernel of the
##  epimorphism onto $G$; the default for <ker> is $2$.
##
DeclareGlobalFunction( "ConstructV4G" );


#############################################################################
##
#F  ConstructProj( <tbl>, <irrinfo> )
#F  ConstructProjInfo( <tbl>, <kernel> )
##
##  `ConstructProj' constructs the irreducible characters of record encoding
##  the ordinary character table <tbl> from projective characters of tables
##  of factor groups,
##  which are stored in the `ProjectivesInfo' (see~"ProjectivesInfo") value
##  of the smallest factor;
##  the information about the name of this factor and the projectives to
##  take is stored in <irrinfo>.
##
##  `ConstructProjInfo' takes an ordinary character table <tbl> and a list
##  <kernel> of class positions of a cyclic kernel of order dividing $12$,
##  and returns a record with the components
##  \beginitems
##  `tbl' &
##      a character table that is permutation isomorphic with <tbl>,
##      and sorted such that classes that differ only by multiplication with
##      elements in the classes of <kernel> are consecutive,
##
##  `projectives' &
##      a record being the entry for the `projectives' list of the table of
##      the factor of <tbl> by <kernel>,
##      describing this part of the irreducibles of <tbl>, and
##
##  `info' &
##      the value of <irrinfo>.
##  \enditems
##
##  In order to encode a library table $t$ as a ``projective table'' relative
##  to another library table $f$, say, one has to do the following.
##  First the factor fusion from $t$ to $f$ must be stored on the table of
##  $t$, and $t$ is written to a library file.
##  Then the result of `ConstructProjInfo', called for $t$ and the kernel of
##  the factor fusion, is used as follows.
##  The list containing `"ConstructProj"' at its first position and the
##  `info' component is added as last entry of the `MOT' call for this
##  library version.
##  The `projectives' component is added to the `ProjectivesInfo' list of
##  $f$, and a new library version of $f$ is produced (this contains the new
##  projectives via an `ARC' call).
##  Finally, `etc/maketbl' is called in order to store the projection for the
##  factor fusion in the `ctprimar.tbl' data.
##
DeclareGlobalFunction( "ConstructProj" );

DeclareGlobalFunction( "ConstructProjInfo" );


#############################################################################
##
#F  ConstructDirectProduct( <tbl>, <factors> )
#F  ConstructDirectProduct( <tbl>, <factors>, <permclasses>, <permchars> )
##
##  is a special case of a `construction' call for a library table <tbl>.
##
##  The direct product of the tables described in the list <factors> is
##  constructed, and all its components stored not yet in <tbl> are
##  added to <tbl>.
##
##  The `computedClassFusions' component of <tbl> is enlarged
##  by the factor fusions from the direct product to the factors.
##
##  If the optional arguments <permclasses>, <permchars> are given then
##  classes and characters of the result are sorted accordingly.
##
##  <factors> must have length at least two;
##  use `ConstructPermuted' (see~"ConstructPermuted") in the case of only
##  one factor.
##
DeclareGlobalFunction( "ConstructDirectProduct" );


#############################################################################
##
#F  ConstructSubdirect( <tbl>, <factors>, <choice> )
##
##  The library table <tbl> is completed with help of the table obtained by
##  taking the direct product of the tables with names in the list <factors>,
##  and then taking the table consisting of the classes in the list <choice>.
##
##  Note that in general, the restriction to the classes of a normal subgroup
##  is not sufficient for describing the irreducible characters of this
##  normal subgroup.
##
DeclareGlobalFunction( "ConstructSubdirect" );


#############################################################################
##
#F  ConstructIsoclinic( <tbl>, <factors> )
#F  ConstructIsoclinic( <tbl>, <factors>, <nsg> )
##
##  constructs first the direct product of library tables as given by the
##  list <factors>, and then constructs the isoclinic table of the result.
##
DeclareGlobalFunction( "ConstructIsoclinic" );


#############################################################################
##
#F  ConstructPermuted( <tbl>, <libnam>[, <prmclasses>, <prmchars>] )
##
##  The library table <tbl> is completed with help of the library table with
##  name <libnam>, whose classes and characters must be permuted by the
##  permutations <prmclasses> and <prmchars>, respectively.
##
DeclareGlobalFunction( "ConstructPermuted" );


#############################################################################
##
#F  ConstructFactor( <tbl>, <libnam>, <kernel> )
##
##  The library table <tbl> is completed with help of the library table with
##  name <libnam>, by factoring out the classes in the list <kernel>.
##
DeclareGlobalFunction( "ConstructFactor" );


#############################################################################
##
#F  ConstructClifford( <tbl>, <cliffordtable> )
##
##  constructs the irreducibles of the ordinary character table <tbl> from
##  the Clifford matrices stored in `<tbl>.cliffordTable'.
##
DeclareGlobalFunction( "ConstructClifford" );


#############################################################################
##
##  7. Character Tables of Coprime Central Extensions
##


#############################################################################
##
#F  CharacterTableOfCommonCentralExtension( <tblG>, <tblmG>, <tblnG>, <id> )
##
##  Let <tblG> be the ordinary character table of a group $G$, say,
##  and let <tblmG> and <tblnG> be the ordinary character tables of central
##  extensions $m.G$ and $n.G$ of $G$ by cyclic groups of prime orders $m$
##  and $n$, respectively, with $m \not= n$.
##  We assume that the factor fusions from <tblmG> and <tblnG> to <tblG> are
##  stored on the tables.
##  `CharacterTableOfCommonCentralExtension' returns a record with the
##  following components.
##
##  \beginitems
##  `tblmnG' &
##      the character table $t$, say, of the corresponding central extension
##      of $G$ by a cyclic group of order $m n$ that factors through $m.G$
##      and $n.G$; the `Identifier' value of this table is <id>,
##
##  `IsComplete' &
##      `true' if the `Irr' value is stored in $t$, and `false' otherwise,
##
##  `irreducibles' &
##      the list of irreducibles of $t$ that are known;
##      it contains the inflated characters of the factor groups $m.G$ and
##      $n.G$, plus those irreducibles that were found in tensor
##      products of characters of these groups.
##  \enditems
##
##  Note that the conjugacy classes and the power maps of $t$ are uniquely
##  determined by the input data.
##  Concerning the irreducible characters, we try to extract them from the
##  tensor products of characters of the given factor groups by reducing
##  with known irreducibles and applying the LLL algorithm
##  (see~"ref:ReducedClassFunctions" and~"ref:LLL"
##  in the {\GAP} Reference Manual).
##
DeclareGlobalFunction( "CharacterTableOfCommonCentralExtension" );


#############################################################################
##
#F  IrreduciblesForCharacterTableOfCommonCentralExtension(
#F      <tblmnG>, <factirreducibles>, <zpos>, <needed> )
##
##  This function implements a heuristic for finding the missing irreducible
##  characters of a character table whose table head is constructed with
##  `CharacterTableOfCommonCentralExtension'
##  (see~"CharacterTableOfCommonCentralExtension").
##  Currently reducing tensor products and applying the LLL algorithm are
##  the only ingredients.
##
DeclareGlobalFunction(
    "IrreduciblesForCharacterTableOfCommonCentralExtension" );


#############################################################################
##
##  8. Miscellaneous
#8
##


#############################################################################
##
#F  PossibleActionsForTypeGA( <tblG>, <tblGA> )
##
##  Let <tblG> and <tblGA> be the ordinary character tables of a group $G$
##  and of an extension $\tilde{G}$ of $G$ by an automorphism of order $A$,
##  say.
##
##  `PossibleActionsForTypeGA' returns the list of all those permutations
##  that may describe the action of $\tilde{G}$ on the classes
##  of <tblG>, that is, all table automorphisms of <tblG> that have order
##  dividing $A$ and permute the classes of <tblG> compatibly with the fusion
##  from <tblG> into <tblGA>.
##
DeclareGlobalFunction( "PossibleActionsForTypeGA" );
#T Replace the function by one that takes a perm. group and a fusion map!

#T The following two functions belong to the package for interactive
#T character table constructions;
#T but they are needed for `CharacterTableOfCommonCentralExtension'.

#############################################################################
##
#F  ReducedX( <tbl>, <redresult>, <chars> )
##
##  Let <tbl> be an ordinary character table, <redresult> be a result record
##  returned by `Reduced' when called with first argument <tbl>, and <chars>
##  be a list of characters of <tbl>.
##  `ReducedX' first reduces <chars> with the `irreducibles' component of
##  <redresult>; if new irreducibles are obtained this way then the
##  characters in the `remainders' component of <redresult> are reduced with
##  them; this process is iterated until no more irreducibles are found.
##  The function returns a record with the following components.
##
##  \beginitems
##  `irreducibles' &
##      all irreducible characters found during the process, including the
##      `irreducibles' component of <redresult>,
##
##  `remainders' &
##      the reducible characters that are left from <chars> and the
##      `remainders' component of <redresult>.
##  \enditems
##
DeclareGlobalFunction( "ReducedX" );


#############################################################################
##
#F  TensorAndReduce( <tbl>, <chars1>, <chars2>, <irreducibles>, <needed> )
##
##  Let <tbl> be an ordinary character table, <chars1> and <chars2> be two
##  lists of characters of <tbl>, <irreducibles> be a list of irreducible
##  characters of <tbl>, and <needed> be a nonnegative integer.
##  `TensorAndReduce' forms the tensor products of the characters in <chars1>
##  with the characters in <chars2>, and reduces them with the characters in
##  <irreducibles> and with all irreducible characters that are found this
##  way.
##  The function returns a record with the following components.
##
##  \beginitems
##  `irreducibles' &
##      all new irreducible characters found during the process,
##
##  `remainders' &
##      the reducible characters that are left from the tensor products.
##  \enditems
##
##  When at least <needed> new irreducibles are found then the process is
##  stopped immediately, without forming more tensor products.
##
##  For example, <chars1> and <chars2> can be chosen as lists of irreducible
##  characters with prescribed kernels such that the tensor products have a
##  prescribed kernel, too.
##  In this situation, <irreducibles> can be restricted to the list of those
##  known irreducible characters that can be constituents of the tensor
##  products, and <needed> can be chosen as the number of all missing
##  irreducibles of that kind.
##
DeclareGlobalFunction( "TensorAndReduce" );


#############################################################################
##
#E

