/*  Note: You are free to use whatever license you want.
    Eventually you will be able to edit it within Glade. */

/*  project1
 *  Copyright (C) <YEAR> <AUTHORS>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include "gatosrc.h"
#include "gatosig.h"

GtkWidget *win_main;
GtkWidget *win_sel;
GtkWidget *win_edit;
GtkWidget *win_msg;
GtkWidget *win_cal;


void ViewJob(void);
void DelJob(void);


void 
Message(char *title, char *msg)
{
           win_msg=create_win_msg (title,msg);
           gtk_window_set_modal(GTK_WINDOW(win_msg),1);           
           gtk_widget_show(win_msg);
}


void 
Refresh(void)
{
    GtkCList *grd_job;
    char *tpl[5],s[255];
    FILE *pf;
    int i;

    grd_job=GTK_CLIST(gtk_object_get_data(GTK_OBJECT(win_main), "grd_jobs"));
    gtk_clist_clear(grd_job);
    gtk_clist_freeze(grd_job);          
    pf=popen("atq","r");
    
    if(!pf) return;

    fgets(s,254,pf);
    while (!feof(pf))
    {
       tpl[0]=strtok(s,"\t ");
       for(i=1;i<5;i++){           
           tpl[i]=strtok(NULL,"\t ");
/*           g_print("tpl '%s'\n",tpl[i]);*/
       }
           
       gtk_clist_append(grd_job,tpl);
       fgets(s,254,pf);          
    }

    pclose(pf);
    gtk_clist_thaw(grd_job);       
}


char *FILENAME=NULL;
int GRDSELROW=-1;

void 
SetSpinBtsDate(int d,int m, int y)
{
    GtkSpinButton *sbt;
    
    sbt=GTK_SPIN_BUTTON(gtk_object_get_data(GTK_OBJECT(win_main), "sbt_day"));    
    gtk_spin_button_set_value(sbt,d);
    sbt=GTK_SPIN_BUTTON(gtk_object_get_data(GTK_OBJECT(win_main), "sbt_month"));    
    gtk_spin_button_set_value(sbt,m);    
    sbt=GTK_SPIN_BUTTON(gtk_object_get_data(GTK_OBJECT(win_main), "sbt_year"));    
    gtk_spin_button_set_value(sbt,y);    
}

void 
SetSpinBtsHour(int hh,int mm)
{
    GtkSpinButton *sbt;
    
    sbt=GTK_SPIN_BUTTON(gtk_object_get_data(GTK_OBJECT(win_main), "sbt_hour"));    
    gtk_spin_button_set_value(sbt,hh);    
    sbt=GTK_SPIN_BUTTON(gtk_object_get_data(GTK_OBJECT(win_main), "sbt_minute"));    
    gtk_spin_button_set_value(sbt,mm);        
}


void 
SetSpinBts(int d,int m, int y, int hh,int mm)
{
    SetSpinBtsDate(d,m,y);
    SetSpinBtsHour(hh,mm);
}

void 
GetSpinBtsDate(int *d,int *m, int *y)
{
    GtkSpinButton *sbt;
    
    sbt=GTK_SPIN_BUTTON(gtk_object_get_data(GTK_OBJECT(win_main), "sbt_day"));    
    *d=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sbt));    
    sbt=GTK_SPIN_BUTTON(gtk_object_get_data(GTK_OBJECT(win_main), "sbt_month"));    
    *m=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sbt));        
    sbt=GTK_SPIN_BUTTON(gtk_object_get_data(GTK_OBJECT(win_main), "sbt_year"));    
    *y=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sbt));        
}

void 
SetCmbStat(void)
{
    GtkCombo *cmb;
    
    cmb=gtk_object_get_data(GTK_OBJECT(win_main), "cmb_action");    
    gtk_entry_set_editable(GTK_ENTRY(cmb->entry),FALSE);
    cmb=gtk_object_get_data(GTK_OBJECT(win_main), "cmb_queue");    
    gtk_entry_set_editable(GTK_ENTRY(cmb->entry),FALSE);    
}

void 
MkCmmdLine(char *cmmd)
{
   char aux[100], *auxp;   
   gpointer wdg;   
   int d,m,y;
   
   strcpy(cmmd,"at ");

   wdg=gtk_object_get_data(GTK_OBJECT(win_main), "cbt_mail");    
   if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg)))
      strcat(cmmd," -m ");


   wdg=gtk_object_get_data(GTK_OBJECT(win_main), "cbt_queue");    
   if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg)))
      {
          wdg=gtk_object_get_data(GTK_OBJECT(win_main), "cmb_queue");           
          auxp=gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(wdg)->entry));      
          strcat(cmmd," -q ");
          strcat(cmmd,auxp);          
          strcat(cmmd," ");          
      } 
      
   wdg=gtk_object_get_data(GTK_OBJECT(win_main), "edt_cmbtime");              
   auxp=gtk_entry_get_text(GTK_ENTRY(wdg));
   g_print("%s\n",auxp);
   if(!strcmp(auxp,"Specified"))
   {
       wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_hour");           
       d=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(wdg));
          
       wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_minute");           
       m=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(wdg));          
      
       sprintf(aux," %02d:%02d ",d,m);
       strcat(cmmd,aux);             
   }else{
      strcat(cmmd," ");            
      strcat(cmmd,auxp);         
   }

   wdg=gtk_object_get_data(GTK_OBJECT(win_main), "edt_cmbday");              
   auxp=gtk_entry_get_text(GTK_ENTRY(wdg));
   g_print("%s\n",auxp);   
   if(!strcmp(auxp,"Specified"))
   {      
      wdg=gtk_object_get_data(GTK_OBJECT(win_main), "cbt_day");    
      if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wdg)))
         {
             wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_day");           
             d=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(wdg));
          
             wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_month");           
             m=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(wdg));          
          
             wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_year");           
             y=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(wdg));          
          
             sprintf(aux," %02d/%02d/%04d ",m,d,y);
             strcat(cmmd,aux);
         }
    }else{
      strcat(cmmd," ");             
      strcat(cmmd,auxp);         
   }
      
/*    wdg=gtk_object_get_data(GTK_OBJECT(win_main), "cmb_action");   
    if(strcmp(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(wdg)->entry)),"Command"))
      {
          sprintf(aux," -f %s ");
      }
    
     
     g_print("%s   !!!!",cmmd);      */
}

int
main (int argc, char *argv[])
{

  time_t tint;
  struct tm *tst;

  gtk_set_locale ();
  gtk_init (&argc, &argv);


  tint=time(NULL); 
  tst=localtime(&tint);

  add_pixmap_directory("/usr/share/gato");
  add_pixmap_directory("/usr/local/share/gato");  
  win_main = create_win_main(); 
  SetSpinBts(tst->tm_mday,tst->tm_mon+1,1900+tst->tm_year,tst->tm_hour,tst->tm_min);
  SetCmbStat();
/*  free(tst);*/
  Refresh();
  
  gtk_widget_show (win_main);

  gtk_main ();
  return 0;
}


void
on_saveas_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void 
Quit(void)
{
   gtk_main_quit();    
}

void
on_quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Quit();
}


void
on_refresh_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    Refresh();
}


void
on_delete_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   DelJob();
}


void
on_view_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   ViewJob();
}


void
About(void)
{
   Message("About gato",
           "\ngatO ver 0.6.6\n\nA.L.Delgado 2000\naldelgado@arquired.es\n    http://www.arquired.es/users/aldelgado/proy/gato   \n\n");
}

void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   About();
}

void
on_cbt_queue_toggled                   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    GtkFrame *frame;

    frame=gtk_object_get_data(GTK_OBJECT(win_main), "frm_queue");
    
    if(gtk_toggle_button_get_active(togglebutton))    
        gtk_widget_set_sensitive(GTK_WIDGET(frame),1);
    else
        gtk_widget_set_sensitive(GTK_WIDGET(frame),0);
        
}


void
on_cbt_day_toggled                     (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    GtkFrame *frame;

    frame=GTK_FRAME(gtk_object_get_data(GTK_OBJECT(win_main), "frm_date"));
    
    if(gtk_toggle_button_get_active(togglebutton))    
        gtk_widget_set_sensitive(GTK_WIDGET(frame),1);
    else
        gtk_widget_set_sensitive(GTK_WIDGET(frame),0);
        

}


void
on_btn_refresh_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   Refresh();
}


int TXTDIRTY=0;

#define SRC_PIPE 0
#define SRC_FILE 1

void
EditFile(int type,char *fname, int stat)
   {
        GtkText *edt_text;      
        char cmmd[255];        
        FILE *pf;     
           
           TXTDIRTY=0; 
           
	   win_edit=create_win_edit ();
           gtk_window_set_modal(GTK_WINDOW(win_edit),1);           
           
           edt_text=gtk_object_get_data(GTK_OBJECT(win_edit), "edt_text");              
           gtk_text_set_line_wrap (GTK_TEXT (edt_text), TRUE);                      
           gtk_text_freeze (GTK_TEXT (edt_text));
           
           if( type)
              pf=fopen(fname,"r");
           else
              pf=popen(fname,"r");           
              
           if(pf)
               {
                     fgets(cmmd,254,pf);
                     while(!feof(pf))
                        {
                            gtk_text_insert(edt_text,NULL,NULL,NULL,cmmd,strlen(cmmd));
                            fgets(cmmd,254,pf);                            
                        }
                        
                     if(type)
                        fclose(pf);
                     else
                        pclose(pf);
               }
               
           gtk_text_thaw (GTK_TEXT (edt_text));
           gtk_text_set_editable (GTK_TEXT (edt_text), stat);           
           
	   gtk_widget_show(win_edit);   
    }
    

void
ViewJob(void)
{
   char *job;
   GtkCList *grd_job;

   char cmmd[255];

   if(GRDSELROW>-1)
       {   
           grd_job=gtk_object_get_data(GTK_OBJECT(win_main), "grd_jobs");   
           gtk_clist_get_text (grd_job,GRDSELROW,0,&job);
   
           sprintf(cmmd,"at -c %s",job);
	   EditFile(SRC_PIPE,cmmd,FALSE);
       }
       else
       {
           Message("Help","\n\n  Select a job first  \n\n");
       }
}
    
void
on_btn_view_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
   ViewJob();
}


void
DelJob(void)
{
   gchar *job;
   GtkCList *grd_job;
   char cmmd[100];

   if(GRDSELROW>-1)
       {   
           grd_job=gtk_object_get_data(GTK_OBJECT(win_main), "grd_jobs");   
           gtk_clist_get_text (grd_job,GRDSELROW,0,&job);
   
           sprintf(cmmd,"atrm %s",job);
/*           g_print("%s\n",cmmd);*/
           system(cmmd); 
	   
           Refresh();
        }
        else
        {
           Message("Help","\n\n  Select a job first  \n\n");        
        }

}


void
on_btn_del_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
   DelJob();        
}


void
on_grd_jobs_select_row                 (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    GRDSELROW=row;   
}


void
on_grd_jobs_unselect_row               (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    GRDSELROW=-1;   
}


void
on_btn_close_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   FILE *pf;
   guint l;
   gchar *txt;
   GtkText *edt_text;
   
   gtk_widget_hide(win_edit);
   if(TXTDIRTY)
       {
           pf=fopen(FILENAME,"w");
           edt_text=gtk_object_get_data(GTK_OBJECT(win_edit), "edt_text");   
           l=gtk_text_get_length(edt_text);
           txt=gtk_editable_get_chars(GTK_EDITABLE(edt_text),0,l);
           fwrite(txt,1,l,pf);
           fclose(pf);           
           free(txt);
       }
}



void
on_btn_xtra_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkCombo *cmb_action;
    GtkEntry *edt_action;
    gchar *s;
    char cmmd[255],i;
    
    cmb_action=gtk_object_get_data(GTK_OBJECT(win_main), "cmb_action");   
    s=gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cmb_action)->entry));
    
    
    if(strcmp(s,"Command"))
    {
        win_sel=create_win_filesel ();
        gtk_window_set_modal(GTK_WINDOW(win_sel),1); 

        if(FILENAME) free(FILENAME);    
        gtk_widget_show (win_sel);        
    }
    else    
    {
        edt_action=gtk_object_get_data(GTK_OBJECT(win_main), "edt_action");       
        sprintf(cmmd,"%s",gtk_entry_get_text(edt_action));
        i=system(cmmd);
/*        if(!i){
            Message("Error","\n\n  Can't execute command  \n\n");
        }*/
        
    }
}




void
on_ok_button1_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkEntry *edt_action;
  
  FILENAME=(char *)strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (win_sel)));
  gtk_widget_hide(win_sel);
  
  edt_action=gtk_object_get_data(GTK_OBJECT(win_main), "edt_action");   
  gtk_entry_set_text(edt_action,FILENAME);  
  EditFile(SRC_FILE,FILENAME, TRUE);
}


void
on_cancel_button1_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
   FILENAME=NULL;
   gtk_widget_hide(win_sel);   
}



void 
AddJob(void)
{
  FILE *pf;
  char cmmd[500],*auxp,aux[100];
  gpointer wdg;
  MkCmmdLine(cmmd);
 
  wdg=gtk_object_get_data(GTK_OBJECT(win_main), "edt_action");           
  auxp=gtk_entry_get_text(GTK_ENTRY(wdg));       
  
  wdg=gtk_object_get_data(GTK_OBJECT(win_main), "cmb_action");   
  if(strcmp((char *)gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(wdg)->entry)),"Command"))
      {
          sprintf(aux," -f %s ",auxp);
          strcat(cmmd,aux);
          system(cmmd);
      }
      else
      {
     
          pf=popen(cmmd,"w");
          fputs(auxp,pf);
          pclose(pf);

      }
      
   Refresh();      
   
}

void
on_btn_add_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
   AddJob();
}


void
on_edt_text_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
   TXTDIRTY=1;
}


gboolean
on_win_main_delete_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  Quit(); 
  return FALSE;
}


void
on_btn_tbrquit_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   Quit();
}


void
on_btn_tbrrefresh_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  Refresh();
}


void
on_btn_tbrview_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   ViewJob();
}


void
on_btn_tbradd_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   AddJob();
}


void
on_btn_tbrdel_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   DelJob();
}


void
on_btn_tbrhlp_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   About();
}



void
on_btn_msgok_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_hide(win_msg);
}


void
on_hidetoolbar_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   static int status=1;
   GtkWidget *tbr;
   tbr=gtk_object_get_data(GTK_OBJECT(win_main), "handlebox2");         
   if(status)
      gtk_widget_hide(tbr);      
   else   
      gtk_widget_show(tbr);
      
   status=!status;
}


void
on_btn_cal_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
      gpointer cal,wdg;
      int d,m,y;
      
      win_cal=create_win_cal();
      gtk_window_set_modal(GTK_WINDOW(win_cal),1);           
   
      cal=gtk_object_get_data(GTK_OBJECT(win_cal), "cal_selday");   
      GetSpinBtsDate(&d,&m,&y);
      
      gtk_calendar_select_month(cal,m-1,y);
      gtk_calendar_select_day(cal,d);
                                                                                        
      
      gtk_widget_show(win_cal);   
}


void
on_cal_selday_day_selected             (GtkCalendar     *calendar,
                                        gpointer         user_data)
{

}


void
on_btn_okcal_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   guint yy,mm,dd;
   gpointer cal;

   cal=gtk_object_get_data(GTK_OBJECT(win_cal), "cal_selday");      
   gtk_calendar_get_date(cal,&yy,&mm,&dd);
   SetSpinBtsDate(dd,mm+1,yy);
   gtk_widget_hide(win_cal);      
   gtk_widget_destroy(win_cal);   
}


void
on_btn_cancelcal_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_hide(win_cal);   
   gtk_widget_destroy(win_cal);   
}


void
on_edt_cmbday_changed                  (GtkEditable     *editable,
                                        gpointer         user_data)
{
  char *auxp;
  gpointer wdg;

  if(!win_main) return;  
  auxp=gtk_entry_get_text(GTK_ENTRY(editable));        
  if(!strcmp(auxp,"Specified")){
     wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_day");  
     gtk_widget_set_sensitive(GTK_WIDGET(wdg),1);     
     wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_month");  
     gtk_widget_set_sensitive(GTK_WIDGET(wdg),1);     
     wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_year");  
     gtk_widget_set_sensitive(GTK_WIDGET(wdg),1);     
     wdg=gtk_object_get_data(GTK_OBJECT(win_main), "btn_cal");  
     gtk_widget_set_sensitive(GTK_WIDGET(wdg),1);     
  }else{
     wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_day");  
     gtk_widget_set_sensitive(GTK_WIDGET(wdg),0);     
     wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_month");  
     gtk_widget_set_sensitive(GTK_WIDGET(wdg),0);     
     wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_year");  
     gtk_widget_set_sensitive(GTK_WIDGET(wdg),0);     
     wdg=gtk_object_get_data(GTK_OBJECT(win_main), "btn_cal");  
     gtk_widget_set_sensitive(GTK_WIDGET(wdg),0);       
  }
}


void
on_edt_cmbtime_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
  char *auxp;
  gpointer wdg;

  if(!win_main) return;    
  auxp=gtk_entry_get_text(GTK_ENTRY(editable));          
  if(!strcmp(auxp,"Specified")){
     wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_hour");  
     gtk_widget_set_sensitive(GTK_WIDGET(wdg),1);     
     wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_minute");  
     gtk_widget_set_sensitive(GTK_WIDGET(wdg),1);     
  }else{
     wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_hour");  
     gtk_widget_set_sensitive(GTK_WIDGET(wdg),0);     
     wdg=gtk_object_get_data(GTK_OBJECT(win_main), "sbt_minute");  
     gtk_widget_set_sensitive(GTK_WIDGET(wdg),0);     
  }  
}

