import string
import os
import sys
from plot import Gnuplot
from folder import folder

def IR_Raman(root,screen,logfile,start,end,numpts,FWHM,typeofscale,scalefactor,gnuplotexec):
    # inputfilename is the name of a frequency output file

    screen.write("Starting IR_Raman.py\n")

    start=int(start)
    end=int(end)
    numpts=int(numpts)
    scalefactor=float(scalefactor)
    FWHM=float(FWHM) # Could use a float instead, I suppose - will so!

    screenoutput,freq,sym,ir,raman=logfile.getIR_Raman() # Do the donkey work

    if len(ir)==0:
        screen.write("No frequencies found!\n")
        return False

    screen.write(screenoutput)

    # Create a new output folder if necessary (returns the location of it in any case)
    gaussdir=folder(screen,logfile)

    # Do the IR
    dofreqs(screen,root,"IR",freq,sym,ir,start,end,numpts,FWHM,typeofscale,scalefactor,gaussdir,gnuplotexec)

    # Do the Raman
    if len(raman)>0:
        dofreqs(screen,root,"Raman",freq,sym,raman,start,end,numpts,FWHM,typeofscale,scalefactor,gaussdir,gnuplotexec)

    screen.write("Finishing IR_Raman.py\n")
    
    return True
        
def dofreqs(screen,root,name,origfreq,sym,act,start,end,numpts,FWHM,typeofscale,scalefactor,gaussdir,gnuplotexec):
    # name is IR or Raman

    screen.write("\n************* Doing the "+name+" *****************\n")
    filename=name+"Spectrum.txt"

    freq=origfreq[:] # Copy so that it won't be changed by the routine

    # Handle the scaling of the frequencies
    scale=[];
    for i in range(len(freq)):
        scale.append(scalefactor)
    if typeofscale=="Gen":
        screen.write("Going to scale with a scaling factor of "+str(scalefactor)+"\n")
        general=True
    else:
        screen.write("Going to use individual scaling factors\n")
        screen.write("Looking for scaling factors in "+filename+"...")
        try:
            inputfile=open(os.path.join(gaussdir,filename),"r")
        except IOError:
            screen.write("not found\nGoing to use general scale factor of "+str(scalefactor)+" instead\n")
            general=True
        else:
            screen.write("found\n")
            general=False
            line=inputfile.readline(); line=inputfile.readline()
            i=0
            line=inputfile.readline().split('\t')
            while len(line)>2 and line[4]!='': # Read in the individual scaling factors
                sf=line[7]
                if sf=='':
                    sf=scalefactor
                else:
                    sf=float(sf)
                scale[i]=sf
                i=i+1
                line=inputfile.readline().split('\t')
       
    data=freq[:]

    for i in range(len(freq)): # Scale the freqs
        freq[i]*=scale[i]
    
    # Convolute the spectrum

    spectrum=[0]*numpts
    width=end-start
    a=FWHM*FWHM/4
    for x in range(0,len(freq)):
        for y in range(0,numpts): # the index in the array
            realy=width*(y+1)/numpts+start # the energy in cm-1 we are currently looking at
            z=act[x]*a/( (realy-freq[x])**2+a )                
            spectrum[y]=spectrum[y]+z

    outputfile=open(os.path.join(gaussdir,filename),"w")
    screen.write("Writing scaled spectrum to "+filename+"\n")
    outputfile.write("Spectrum\t\t\tNormal Modes\n")
    outputfile.write("Freq (cm-1)\t"+name+" act\t\tMode\tLabel\tFreq (cm-1)\t"+name+" act\t")
    outputfile.write("Scaling factors\tUnscaled freq\n")
    for x in range(0,numpts):
        if spectrum[x]<1e-20:
            spectrum[x]=0
        realx=width*(x+1)/numpts+start
        outputfile.write(str(realx)+"\t"+str(spectrum[x]))
        if x<len(freq): # Write the activities (assumes more pts to plot than freqs - fix this)
            outputfile.write("\t\t"+str(x+1)+"\t"+sym[x]+"\t"+str(freq[x])+"\t"+str(act[x]))
            outputfile.write("\t"+str(scale[x])+"\t"+str(data[x]))
        outputfile.write("\n")
    outputfile.close()

    # Draw using Gnuplot

    screen.write("Plotting with Gnuplot\n")

    if name=="IR": # Plot the IR upside down (and move the title as a result)
        gnuplotcommands="set xlabel 'Frequency (cm-1)'\nset ylabel '"+name+" activity'\nset yrange [*:*] reverse\nset xrange [*:*] reverse\nset key bottom\n"
    else:
        gnuplotcommands="set xlabel 'Frequency (cm-1)'\nset ylabel 'Raman activity'\n"

    gnuplotcommands=gnuplotcommands+"plot '"+os.path.join(gaussdir,filename)+"' using 1:2 title '"+name+" spectrum scaled by "        

    if general==True:
        gnuplotcommands=gnuplotcommands+str(scalefactor)+"' with lines\n"
    else:
        gnuplotcommands=gnuplotcommands+"individual scaling factors' with lines\n"    
        
    Gnuplot(root,gnuplotexec,gnuplotcommands,name+" Spectrum")
    


# The main start
if __name__=="__main__": # if it's being run (and not imported)
    IR_Raman(sys.stdout,"G:/fullC9freq.log",0,4000,1000,5)
