import re

def NMR(screen,logfile,rb1,theory,rb2,nmrstandards):

    screen.write("Starting NMR.py\n")

    tensors,comment=logfile.getNMR()

    # Try to match "THEORY(leveloftheory)"
    match=re.findall(r"THEORY\(([^)]*)\)",comment)
    try:
        leveloftheory=match[0]
    except: # No matches (Easier to Ask Forgiveness than Permission!)
        leveloftheory=""
    # Try to match "NAME(leveloftheory)"
    match=re.findall(r"NAME\(([^)]*)\)",comment)
    try:
        name=match[0]
    except:
        name=""
       

    screen.write("Log file comment:%s" % comment)

    if leveloftheory=="":
        screen.write("Level of theory according to comment: %s\n" % "Unspecified")
    else:
        screen.write("Level of theory according to comment: %s\n" % leveloftheory)
    if name=="":
        screen.write("Name of compound according to comment: %s\n" % "Unspecified")
    else:
        screen.write("Name of compound according to comment: %s\n" % name)

    for atom,value in tensors:
        screen.write("Atom %s with value %f\n" % (atom,value) )
    screen.write("\n")

    if rb1=="Extract":
        screen.write("Finishing NMR.py\n")
        return True
    elif rb1=="Comment":
        if leveloftheory!="":
            theory=leveloftheory
        else:
            screen.write("Cannot use comment!\n")
            return False

    if rb2=="Standard":
        # Add new standard to nmrstandards.txt
        if name=="":
            screen.write("You need to name the standard\n")
            return False
        newdict = {}
        newdict['theory'] = theory
        newdict['name'] = name

        for atom,value in tensors:
            if newdict.has_key(atom):
                oldvalue = newdict[atom]
                if oldvalue!=value:
                    screen.write("More than one value for atom %s\n" % atom)
                    return False
            else:
                newdict[atom] = value
        nmrstandards.nmrdata.append(newdict)
        nmrstandards.save()
        
    elif rb2=="Calculate":
        # Calculate the relative shifts
        screen.write("%s\nCalculation of relative chemical shift\n%s\n" % ("*"*38,"*"*38) )
        screen.write("Level of theory: %s\n" % theory)

        stdname = []
        # Find the names of all of the standards for this level of theory
        for nmrstandard in nmrstandards:
            if nmrstandard['theory']==theory:
                stdname.append(nmrstandard['name'])
        if len(stdname)==0:
            screen.write("No nmr standards available\n")
        else:
            screen.write("Available standards: %s\n" % "\t".join(stdname) )
        
            for nmrstandard in nmrstandards:
                if nmrstandard['theory']==theory:
                    screen.write("\nRelative to %s\n" % nmrstandard['name'])
                    for atom,value in tensors:
                        if nmrstandard.has_key(atom):
                            screen.write("Atom %s has rel. value %f\n" % (atom,nmrstandard[atom]-value) )

    else:
        assert 1==0
        
    screen.write("Finishing NMR.py\n")
    return True
        

