import os
import sys

from plot import Gnuplot
from tempfile import mkstemp
from Tkinter import *

def SCF(root,screen,logfile,numpoints,gnuplotexec):
    
    screen.write("Starting SCF.py\n")

    numpoints=int(numpoints)

    screenoutput,gnuplotdata=logfile.getSCF()
    screen.write(screenoutput)
    
    if gnuplotdata: # If we have found something
        if len(gnuplotdata)>=numpoints+2: # If there are two points to plot
            gnuplotdata=gnuplotdata[numpoints:]
            tmpfile_a_des,tmpfile_a=mkstemp()
            # For windows gnuplot we need to replace the backslashes with forward slashes
            # (especially if your name is noelo'~1, because then you need the double quotation marks)
            newname=""
            for x in tmpfile_a:
                a=x
                if x=="\\":
                    a='/'
                newname+=a            
            gnuplotfile=file(tmpfile_a,"w")
            
            for x in range(0,len(gnuplotdata)):
                gnuplotfile.write(str(x+1)+"\t"+gnuplotdata[x]+"\n")
            gnuplotfile.close()
            gnuplotcommands="set yrange [0:*]\nset xlabel 'SCF convergence step'\nset ylabel 'Deviation from targets'\n"
            gnuplotcommands=gnuplotcommands+'plot "'+newname+'" notitle with lines, "'+newname+'" notitle\n'
  
            Gnuplot(root,gnuplotexec,gnuplotcommands,"Plot of SCF deviation vs Iteration")
            
            os.close(tmpfile_a_des)
            os.remove(tmpfile_a)
        else:
            screen.write("I need at least two points to plot\n")
    else:
        screen.write("You need to use #P to find SCF convergence information\n")

    screen.write("Finishing SCF.py\n")

# The start
if __name__=="__main__": # SCF.py is being run (not imported)
    root=Tk()
    SCF(root,sys.stdout,"input/TD.out","0")
    mainloop()
