#define COMMENT(X)

COMMENT((
Common definitions for the GNU Pascal Compiler and the Run Time System

This file is also included in some source files of the compiler to
keep the definitions unique. It defines only numeric macros, uses
`#' directives and `#if 0' for comments, so it can be included in
both C and Pascal files.

Copyright (C) 1991-2003 Free Software Foundation, Inc.

This file is part of GNU Pascal.

GNU Pascal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Pascal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Pascal; see the file COPYING. If not, write to the
Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.

As a special exception, if you link this file with files compiled
with a GNU compiler to produce an executable, this does not cause
the resulting executable to be covered by the GNU General Public
License. This exception does not however invalidate any other
reasons why the executable file might be covered by the GNU General
Public License.))

#ifndef _RTS_CONSTANTS_H_
#define _RTS_CONSTANTS_H_

#define FILE_BUFSIZE 16384

COMMENT ((@@ The compiler needs to know the size of struct Fdr on the target
             (could be avoided if file buffers were allocated from heap, but ...).
             sizeof (struct Fdr) would be wrong when cross-compiling. Furthermore,
             when file.c will have been translated to Pascal, struct Fdr is not
             available in C. The right solution will be to declare it as a Pascal
             record in the compiler. For now, make a generous estimate of the size
             (constant!), and verify it in file.c (compiled by the target compiler!).
                 (integer fields, pointer fields, buffer, reserve)))
#define FDR_Size (9 * 8 + 16 * 16 + FILE_BUFSIZE)

COMMENT (File kind: fourth parameter to _p_InitFDR)
#define fkind_TEXT       1
#define fkind_UNTYPED    2
#define fkind_PACKED     4
#define fkind_EXTERN     8
#define fkind_DIRECT    16
#define fkind_BYTE      32
#define fkind_FILENAME  64
#define fkind_BINDABLE 128

COMMENT ((The following defines specify the argument types of the routines _p_Internal_Read,
          _p_Internal_Write etc. that get variable number and types of arguments.))
#define P_S_BYTE        1 COMMENT ((READ: signed char *))
#define P_S_SHORT       2 COMMENT ((READ: signed short *))
#define P_S_INT         3 COMMENT ((READ: signed int *          WRITE: signed int))
#define P_S_LONG        4 COMMENT ((READ: signed long *))
#define P_S_LONGLONG    5 COMMENT ((READ: signed long long *    WRITE: signed long long))
#define P_U_BYTE        6 COMMENT ((READ: unsigned char *))
#define P_U_SHORT       7 COMMENT ((READ: unsigned short *))
#define P_U_INT         8 COMMENT ((READ: unsigned int *        WRITE: unsigned int))
#define P_U_LONG        9 COMMENT ((READ: unsigned long *))
#define P_U_LONGLONG   10 COMMENT ((READ: unsigned long long *  WRITE: unsigned long long))
#define P_SHORT_REAL   11 COMMENT ((READ: float *))
#define P_REAL         12 COMMENT ((READ: double *))
#define P_LONG_REAL    13 COMMENT ((READ: long double *         WRITE: long double))
#define P_CHAR         14 COMMENT ((READ: char *                WRITE: int))
#define P_BOOL         15 COMMENT ((READ: Boolean *             WRITE: int))
#define P_ENUM         16 COMMENT ((READ: char **, int, int*    WRITE: char **, int, int))
#define P_ANY_STRING   17 COMMENT ((                            WRITE: (char *), int))
#define P_STRING       18 COMMENT ((READ: char *, int *, int))
#define P_SHORT_STRING 19 COMMENT ((READ: char *, char *, int))
#define P_FIXED_STRING 20 COMMENT ((READ: char *, int))
#define P_CSTRING      21 COMMENT ((READ: char *, int))
#define P_LINE         22 COMMENT ((READ: void                  WRITE: void))
#define FIX_WIDTH_MASK 32 COMMENT ((minimum width: additional int parameter))
#define FIX2_REAL_MASK 64 COMMENT ((fixed number of decimals (real, FIX_WIDTH_MASK): additional int parameter))

COMMENT ((Keep these masks different bits. Input and output masks may overlap))
#define VAL_MASK                  1
#define FORMAT_STRING_MASK        1
#define READ_WRITE_STRING_MASK    2

COMMENT ((Input masks))
#define INT_READ_BASE_SPEC_MASK   4 COMMENT ((allow the base specifier (n#) (integer)))
#define INT_READ_HEX_MASK         8 COMMENT ((allow the hex specifier ($) (integer)))
#define NUM_READ_CHK_WHITE_MASK  16 COMMENT ((require whitespace after the number (integer, real)))
#define REAL_READ_SP_ONLY_MASK   32 COMMENT ((do not accept Extended Pascal real number format extension (real)))

COMMENT ((Output masks))
#define NEG_ZERO_WIDTH_ERROR_MASK 4 COMMENT ((give an error when field width < 0 (FIX_WIDTH_MASK)))
#define NEG_WIDTH_ERROR_MASK      8 COMMENT ((give an error when field width < 0 (FIX_WIDTH_MASK)))
#define NEG_WIDTH_LEFT_MASK      16 COMMENT ((left adjusted output when the field width < 0 (FIX_WIDTH_MASK)))
#define NEG_WIDTH_CENTER_MASK    32 COMMENT ((centered output when field width < 0 (FIX_WIDTH_MASK)))
#define REAL_NOBLANK_MASK        64 COMMENT ((output without a leading blank (real)))
#define REAL_CAPITAL_EXP_MASK   128 COMMENT ((with a capital `E' for the exponent instead of the default which is a lower case `e' (real)))
#define CLIP_STRING_MASK        256 COMMENT ((clip strings that exceed the given width (P_ANY_STRING, FIX_WIDTH_MASK)))
#define TRUNCATE_STRING_MASK    512 COMMENT ((truncate output that exceeds capacity rather than generating an error (for WriteStr)))

COMMENT ((Implementation dependent string lengths))

COMMENT ((Length of the `Name' field of `BindingType'.
          Any length should work, as long as the name fits in. Passed as
          var parameter to the RTS. The name is copied to the heap in the
          RTS (Length (Name) bytes). This should be a reasonable length.))
#define BINDING_NAME_LENGTH 2048

COMMENT ((Length of the string type returned by `Date' and `Time', e.g. `14 Nov 1993' or `22:55:26'))
#define GPC_DATE_TIME_LENGTH 11

#endif
