// -*- C++ -*-

/* 
 * GChemPaint library
 * mesomer.h 
 *
 * Copyright (C) 2005 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_MESOMER_H
#define GCHEMPAINT_MESOMER_H

#include <gcu/object.h>
#include <map>

using namespace std;
using namespace gcu;

extern TypeId MesomerType;

class gcpMesomery;
class gcpMesomeryArrow;
class gcpMolecule;

class gcpMesomer: public Object
{
public:
	gcpMesomer ();
	virtual ~gcpMesomer ();
	
	gcpMesomer (gcpMesomery *mesomery, gcpMolecule *molecule) throw (std::invalid_argument);
	virtual bool Load(xmlNodePtr);
	virtual bool OnSignal (SignalId Signal, Object *Child);
	virtual double GetYAlign ();
	void AddArrow (gcpMesomeryArrow *arrow, gcpMesomer *mesomer) throw (std::invalid_argument);
	void RemoveArrow (gcpMesomeryArrow *arrow, gcpMesomer *mesomer);
	bool Validate () {return Arrows.size () > 0;}
	map<gcpMesomer *, gcpMesomeryArrow *> *GetArrows () {return &Arrows;}
	gcpMolecule *GetMolecule () {return Molecule;}

private:
	gcpMolecule *Molecule;
	map<gcpMesomer *, gcpMesomeryArrow *> Arrows;
};

#endif	//GCHEMPAINT_MESOMER_H
