#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "help.h"
#include "conf.h"
#include "msgbox.h"
#include "win_filesel.h"


GList 
      *minute=NULL,
      *hour=NULL,
      *day=NULL,
      *month=NULL,      
      *wday=NULL,
      *smmonth=NULL,      
      *smwday=NULL,	  
      *lsts[5],
      *smlsts[5];

GtkWidget *win_main;
GtkWidget *win_citem;
GtkWidget *win_cmmd;
GtkWidget *win_sel;
GtkWidget *win_edit;
GtkWidget *win_cal;
GtkWidget *win_druid;


guint DEFCONTEXT;

static int   TXTDIRTY=0;
int   CRONDIRTY=0;
int   SETDIRTY=0;

char *FILENAME=NULL,
      TMPFILENAME[255]="";
int   SIMPMODE=0, STDBAR=1, TIMEBAR=1; 

gint GRDSELROW=-1,GRDLNSELROW=-1,GRDSELCOL=-1;

char CRONTABLN[1000]="";


/*void New(void);
void Quit(void);
void Open(void);
void AddLine (void);
void DelLine (void);
void About(void);
void Help(void);
void SvAs(void);
int  SvCronFile(void);

void Message(char *title, char *msg);
int  LdCronFile(char *lname,int fullpath);

int  IsComentLn(char *IN_line);
int  ReadLn(FILE *pf,char *s);

void initlsts(void);
void initcmbs(GList *lst);
void EditFile(char *fname, int status);
void ShowCitem(GList *l,int col);
void ShowAction(void);


void on_ok_button_save_clicked (GtkButton *button, gpointer user_data);
void on_ok_button_open_clicked (GtkButton *button, gpointer user_data);*/


void StatusBarMsg(char *s)
{
   static int i=0;
   GtkWidget *sbr;  

    sbr=gtk_object_get_data(GTK_OBJECT(win_main), "sbr_main");
   if(i)
     gtk_statusbar_remove(GTK_STATUSBAR(sbr),DEFCONTEXT,i);

   i=gtk_statusbar_push(GTK_STATUSBAR(sbr),DEFCONTEXT,s);
        
}

void NewWorkFile(void)
{
		if(FILENAME){			
			free(FILENAME);
			FILENAME=NULL;
			gtk_window_set_title(win_main,"Gcrontab");
		}
}



void SetWorkFile(char *fname)
{
	static int nofirst=0;
	if(fname){
		const char *appname="Gcrontab - ";
		char *title=(char *)malloc(strlen(appname)+strlen(fname)+1);
		
		if(FILENAME)
            free(FILENAME);    			

		FILENAME=strdup(fname);
		
		if(!strstr(FILENAME,".gcrontab"))
		{
		   strcpy(title,appname);
		   strcat(title,FILENAME);
		   gtk_window_set_title(win_main,title);
	    }
		nofirst=1;
	}
}


void SetGrdCron(int row,int col,char *txt){
	GtkWidget *grd_cron;

	SETDIRTY=CRONDIRTY=1;
	
	grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");        
    gtk_clist_set_text(GTK_CLIST(grd_cron), row, col, txt);
}

int 
ReadLn(FILE *pf,char *s)
   {
	   int i=0;
	   s[i++]=fgetc(pf);
	   while ( !feof(pf) && s[i-1]!='\n' )
	      s[i++]=fgetc(pf);
	   s[i-1]='\0';
	   return(1);
   }

int 
IsComentLn(char *IN_line)
   {
	   int i=0;
	   while(i<strlen(IN_line))
	      if(IN_line[i]=='#')
	         return(1);
	      else
	         if(IN_line[i]==' ')
	            i++;
	         else
	            return(0);       
	   return(0);
   }



   
int 
LdCronStream(FILE *pf)
	{              
       char s[255],f[5][30],*tpl[6];
       int i,j;
       GtkCList *grd_cron;       		
		
       grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");  
       gtk_clist_clear(grd_cron);
       gtk_clist_freeze(grd_cron);          
       
       j=0;
       while(!feof(pf))
           {
           ReadLn(pf,s);
           if(!s[0])
              goto ext;
              
           if(!IsComentLn(s))
               {
/*                   g_print("%s\n",s);    */
                   sscanf(s,"%s %s %s %s %s %[^,]",f[0],f[1],f[2],f[3],f[4],f[5]);
                   for(i=0;i<6;i++) tpl[i]=strdup(f[i]);
                   gtk_clist_append(grd_cron,tpl);
               }
           }
   ext: gtk_clist_thaw(grd_cron);   
        return(1);		
	}
	

int 
LdSysCrontab(void)
	{
       FILE *p;
       New();	
	   p=popen("crontab -l","r");
		if(p)
		{
	         LdCronStream(p);
	         pclose(p);		
			 return(1);
		}
		return(0);
	}
	
int 
LdCronFile(char *lname,int fullpath)
    {
	   char *filename;
       FILE *pf;
       char s[255],f[5][30],*tpl[6];
       int i,j=0;
       GtkCList *grd_cron;       
	   const char NUM_CRON_FILES=2;
       char *cronpath[2]={
                         "/var/spool/cron/",
                         "/var/spool/cron/crontabs/"
                        };
       
       
       pf=NULL;        
       if(!fullpath){
          for(i=0;i<NUM_CRON_FILES&&!pf;i++){
             filename=(char *)malloc((strlen(cronpath[i])+strlen(lname)+1));
             strcpy(filename,cronpath[i]);
             strcat(filename,lname);          
             pf=fopen(filename,"r");          
             if(!pf)
			   {
				  free(filename);
                  filename=NULL;
               }
          }
       }else{
          struct stat ssb;
          
		  filename=lname;
		  
          stat(lname,&ssb);
          
          if(S_ISREG(ssb.st_mode)){             
             pf=fopen(filename,"r");                    
          }else{
             return(0);
          }
       }
       
		   
       if(!pf) return(0);
       	   
       grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");  
       gtk_clist_clear(grd_cron);
       gtk_clist_freeze(grd_cron);          
       
       j=0;
       while(!feof(pf))
           {
           ReadLn(pf,s);
           if(!s[0])
              goto ext;
              
           if(!IsComentLn(s))
               {
/*                   g_print("%s\n",s);    */
                   sscanf(s,"%s %s %s %s %s %[^,]",f[0],f[1],f[2],f[3],f[4],f[5]);
                   for(i=0;i<6;i++) tpl[i]=strdup(f[i]);
                   gtk_clist_append(grd_cron,tpl);
               }
           }
   ext: gtk_clist_thaw(grd_cron);   
        return(1);
    }	

int
SetWorkMode (char *val)
{	
    GtkWidget *wdg;
   
    wdg=gtk_object_get_data(GTK_OBJECT(win_main), "simplified_mode");   
	
	if(!strcasecmp(val,"simplified"))
	{
	   gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM (wdg),TRUE);
       SIMPMODE=1;
	}else{
	   gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM (wdg),FALSE);	
	   SIMPMODE=0;
	}
	return(0);		
}	

int
SetStdBar (char *val)
{
    GtkWidget *wdg;
   
    wdg=gtk_object_get_data(GTK_OBJECT(win_main), "stdbars");   

	if(!strcasecmp(val,"yes")){ 		
	   gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM (wdg),TRUE);
	   STDBAR=1;
       /*gtk_check_menu_item_toggled (GTK_CHECK_MENU_ITEM (wdg));*/
	}else{ 
	   if(!strcasecmp(val,"no")){
		  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM (wdg),FALSE);	
	      STDBAR=0;       
	   }else
	      return(1);
   }
	
	StdBarShow();
	return(0);		
}	

int
SetTimeBar (char *val)
{
   GtkWidget *wdg;
   
    wdg=gtk_object_get_data(GTK_OBJECT(win_main), "timebar");   	
	if(!strcasecmp(val,"yes")){		
	   gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM (wdg),TRUE);
	   TIMEBAR=1;
	}else if(!strcasecmp(val,"no")){
	   gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM (wdg),FALSE);		
	   TIMEBAR=0;		
	}else
	   return(1);
	    
	TimeBarShow();
	return(0);		
}	

int
SetLastFile (char *val)
{
	SetWorkFile(val);
	return(0);		
}	


int
LdConfig(void)
{
   char s[100];
   Conf_load_callback_descr cbld[]=
   {
       {"WORK_MODE",SetWorkMode},	   
       {"SHOW_STANDARD_BAR",SetStdBar},
	   {"SHOW_TIME_BAR",SetTimeBar},	   
	   {"LAST_WORK_FILE",SetLastFile},	   	   
	   {NULL,NULL}
   };
   sprintf(s,"%s/.gcrontab_options",g_get_home_dir());
   
   conf_Load(s,cbld);
   	
}

void 
Message(char *title, char *msg, char *icon)
{
	       GtkWidget *win_msg;
           /*win_msg=create_winmsg (title,msg);*/
	       win_msg=msgbox_new(title,NULL,msg,icon,ACCEPT_BUTTON);
           gtk_window_set_modal(GTK_WINDOW(win_msg),1);           
           gtk_widget_show(win_msg);	
}


static void
filllst(GList **lst,const char *fmt,int from, int to)
{
   int i;
   char aux[20],*s;
   
   for(i=from;i<=to;i++)
      {
          sprintf(aux,fmt,i);
          s=(char *)strdup(aux);
          *lst=g_list_append(*lst,s);
      }
}

void initlsts(void)
{
    wday=g_list_append(wday,"Mon");
    wday=g_list_append(wday,"Tue");    
    wday=g_list_append(wday,"Wed");
    wday=g_list_append(wday,"Thu");        
    wday=g_list_append(wday,"Fri");    
    wday=g_list_append(wday,"Sat");    
    wday=g_list_append(wday,"Sun");    
    
    month=g_list_append(month,"Jan");
    month=g_list_append(month,"Feb");    
    month=g_list_append(month,"Mar");       
    month=g_list_append(month,"Apr");           
    month=g_list_append(month,"May");           
    month=g_list_append(month,"Jun");           
    month=g_list_append(month,"Jul");           
    month=g_list_append(month,"Aug");           
    month=g_list_append(month,"Sep");           
    month=g_list_append(month,"Oct");           
    month=g_list_append(month,"Nov");           
    month=g_list_append(month,"Dec");           
    
    filllst(&minute,"%02d",0,59);
    filllst(&hour,"%02d",0,23);    
    filllst(&day,"%d",1,31);    
	filllst(&smwday,"%d",0,6);    
	filllst(&smmonth,"%d",1,12);    
    
    lsts[0]=(GList *)minute;
    lsts[1]=(GList *)hour;
    lsts[2]=(GList *)day;
    lsts[3]=(GList *)month;
    lsts[4]=(GList *)wday;     
	
    smlsts[0]=(GList *)minute;
    smlsts[1]=(GList *)hour;
    smlsts[2]=(GList *)day;
    smlsts[3]=(GList *)smmonth;
    smlsts[4]=(GList *)smwday;     	
}    


void initcmbs(GList *lst)
{
    GtkCombo *cmb;
 
    cmb=(GtkCombo *)gtk_object_get_data(GTK_OBJECT(win_citem), "cmb_from");   
    gtk_combo_set_popdown_strings(cmb,lst);
    
    cmb=(GtkCombo*)gtk_object_get_data(GTK_OBJECT(win_citem), "cmb_to");    
    gtk_combo_set_popdown_strings(cmb,lst);    
}


void
EditFile(char *fname, int status)
   {
        GtkText *edt_text;      
        char cmmd[255];        
        FILE *pf;     
        struct stat ssb;
           
           TXTDIRTY=0; 
           
		   
           stat(fname,&ssb);
           if(!S_ISREG(ssb.st_mode)) return;
           
	       win_edit=create_win_edit ();
           gtk_window_set_modal((GtkWindow *)win_edit,1);           
           
           edt_text=GTK_TEXT(gtk_object_get_data(GTK_OBJECT(win_edit), "edt_text"));              
           gtk_text_set_line_wrap (edt_text, TRUE);                      
           gtk_text_freeze (edt_text);
           
           pf=fopen(fname,"r");
           if(pf)
               {
                     fgets(cmmd,254,pf);
                     while(!feof(pf))
                        {
                            gtk_text_insert(edt_text,NULL,NULL,NULL,cmmd,strlen(cmmd));
                            fgets(cmmd,254,pf);                            
                        }
              
                      fclose(pf);
               }
               
           gtk_text_thaw (edt_text);
           gtk_text_set_editable (edt_text, status);           
           
	   gtk_widget_show(win_edit);   
    }



void
on_chk_to_toggled                      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    gpointer frame;

    frame=gtk_object_get_data(GTK_OBJECT(win_citem), "frame1");
    if(gtk_toggle_button_get_active(togglebutton))    
        gtk_widget_set_sensitive(GTK_WIDGET(frame),1);
    else
        gtk_widget_set_sensitive(GTK_WIDGET(frame),0);
}


void
on_chk_step_toggled                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    gpointer sbt;

    sbt=gtk_object_get_data(GTK_OBJECT(win_citem), "sbt_step");
    if(gtk_toggle_button_get_active(togglebutton))
        gtk_widget_set_sensitive(GTK_WIDGET(sbt),1);
    else
        gtk_widget_set_sensitive(GTK_WIDGET(sbt),0);  
}



void
on_btn_add_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
    gpointer from,to,chk,lst,sbt;
    char *tpl[3],aux[10]; 
    GtkCList *grd_cron;           

    
    from=gtk_object_get_data(GTK_OBJECT(win_citem), "cmb_from");
    chk=gtk_object_get_data(GTK_OBJECT(win_citem), "chk_to");    
    lst=gtk_object_get_data(GTK_OBJECT(win_citem), "grd_cron");        
    
	
    
	tpl[0]=strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(from)->entry)));
	
    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk)))
       {        
             to=gtk_object_get_data(GTK_OBJECT(win_citem), "cmb_to");    
             
		     tpl[1]=strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(to)->entry)));
		   
             chk=gtk_object_get_data(GTK_OBJECT(win_citem), "chk_step");    
             if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk)))
                {
                    sbt=(gpointer)gtk_object_get_data(GTK_OBJECT(win_citem), "sbt_step");
                    sprintf(aux,"%d",gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sbt)));
                    tpl[2]=(char *)strdup(aux);
                }
                else
                    tpl[2]=(char *)strdup("");
       }                
    else                    
       {       
           tpl[1]=(char *)strdup("");
           tpl[2]=(char *)strdup("");       
       }
       

      
      grd_cron=gtk_object_get_data(GTK_OBJECT(win_citem), "grd_cronln");        
      gtk_clist_append(grd_cron,tpl);                 
 
}


void
on_btn_del_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
      GtkCList *grd_cronln;       
      
      if(GRDSELROW>-1)
          {
              grd_cronln=gtk_object_get_data(GTK_OBJECT(win_citem), "grd_cronln");        
              gtk_clist_remove (grd_cronln, GRDSELROW);
          }
   
}


void
on_grd_cronln_select_row               (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

}


void
on_grd_cronln_unselect_row             (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

}


void
on_btn_accept_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
    gchar *txt;
    int i;    
    GtkCList *grd_cron, *grd_cronln;

    
    strcpy(CRONTABLN,"");
    grd_cronln=gtk_object_get_data(GTK_OBJECT(win_citem), "grd_cronln");                             
    
    if(grd_cronln->rows>0){
	    for(i=0;i<grd_cronln->rows;i++)
        	{
	           gtk_clist_get_text(grd_cronln,i,0,&txt);
        	   strcat(CRONTABLN,txt);
	           gtk_clist_get_text(grd_cronln,i,1,&txt);           
           
	           if(strcmp(txt,""))
        	       {
        	           strcat(CRONTABLN,"-");                              
                	   strcat(CRONTABLN,txt);                              
	               }
               
        	   gtk_clist_get_text(grd_cronln,i,2,&txt);           
           
	           if(strcmp(txt,""))
        	       {
                	   strcat(CRONTABLN,"/");                              
	                   strcat(CRONTABLN,txt);                              
        	       }               
               
	           if(i+1<grd_cronln->rows)
        	       strcat(CRONTABLN,",");           
	        }
	}
    else
       {
          strcpy(CRONTABLN,"*");
       }
    
    SetGrdCron(GRDSELROW, GRDSELCOL, CRONTABLN);
    gtk_widget_destroy(win_citem);
}


void
on_btn_cancel_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_destroy(win_citem);
}


gboolean
on_win_main_delete_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  Quit();
  return FALSE;
}


void
on_file_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   
}

void 
New (void)
{
     GtkCList *grd_cron;       
     
     NewWorkFile();
	
     grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");  
     gtk_clist_clear(grd_cron);
	
	 SETDIRTY=CRONDIRTY=1;
}

void
on_new_activate                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   New();
}


void
on_ok_button_save_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  SetWorkFile(gtk_file_selection_get_filename (GTK_FILE_SELECTION (win_sel)));
  gtk_widget_destroy(win_sel);    
  SvCronFile();  
}

void
on_ok_button_save_quit_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  SetWorkFile(gtk_file_selection_get_filename (GTK_FILE_SELECTION (win_sel)));
  gtk_widget_destroy(win_sel);    
  SvCronFile();  
  RealQuit();
}

void
on_ok_button_open_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  char *msg; 	

  SETDIRTY=1;
  
  SetWorkFile(gtk_file_selection_get_filename (GTK_FILE_SELECTION (win_sel)));

/*  g_print("<%s>",FILENAME);*/
  if(!FILENAME[0]) return;

  gtk_widget_destroy(win_sel);
  
  if(!LdCronFile(FILENAME,1)){
     Message("Error","\n\n    Can't read crontab file.    \n\n",NULL);  
	 return;
  }
  
  msg=(char *)malloc(strlen(FILENAME)+20);
  strcpy(msg,"Opening ");
  strcat(msg,FILENAME);
  
  StatusBarMsg(msg);
  
  free(msg);
}

void 
Open(void)
{
  
  /*win_sel=create_win_filesel(on_ok_button1_clicked,
		                           on_cancel_button1_clicked);	*/
	
  win_sel=create_win_filesel(on_ok_button_open_clicked,
		                           on_cancel_button1_clicked);	
	    
  gtk_widget_show(GTK_WIDGET(win_sel));  
}

void
on_open_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    Open();
}



int
SvCron(FILE *pf)
{
       gchar *txt;
       int i,j=0;
       GtkCList *grd_cron;       
       
   
       grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");         
       for(j=0;j<grd_cron->rows;j++)
          {
             for(i=0;i<6;i++)
                 {
                    gtk_clist_get_text(grd_cron,j,i,&txt);             
                    fputs(txt,pf);
                    if(i<5)
                        fputc(' ',pf);
                 }
              fputc('\n',pf);
          }
          
}

int 
SvCronFileNamed(char *filename,int statbarmsg)
{
	   char *msg;	 
       FILE *pf;
       gchar *txt;
       int i,j=0;
       GtkCList *grd_cron;       
       
       if(!filename)
       {
          Message("Error","\n\n    No file to save !!!    \n\n",NULL);
          return(0);
       }
       
       pf=fopen(filename,"w");

       if(!pf){
          Message("Write Error","\n\n    Can't write file    \n\n",NULL);          
          return(0);
       }

        SvCron(pf);
        fclose(pf);
	   
	    if(statbarmsg)
		{
		   msg=(char *)malloc(strlen(filename)+20);
		   strcpy(msg,"Saved ");
		   strcat(msg,FILENAME);
		 
		   StatusBarMsg(msg);

           strcpy(msg,"Gcrontab - ");
		   strcat(msg,FILENAME);
		
		   gtk_window_set_title(win_main,msg);
		
		   free(msg);
		}
 

		
       return(1);   

}

int 
SvCronFile(void)
    {
		   SvCronFileNamed(FILENAME,1);
		   CRONDIRTY=0;		  
    }

	
void Save(void)
{
    if(FILENAME)
       SvCronFile();
	else
   	   SvAs();	
}

void
on_save_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	Save();
}

void
SvAs (void)
{
  win_sel=create_win_filesel(on_ok_button_save_clicked,
		                     on_cancel_button1_clicked);	
  gtk_widget_show(GTK_WIDGET(win_sel));
}

void
on_saveas_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   SvAs();
}

char *
GetWorkMode(void){
   return(SIMPMODE?"simplified":"normal");
}

char *
GetStdBar(void){
	return(STDBAR?"yes":"no");
}


char *
GetTimeBar(void){
	return(TIMEBAR?"yes":"no");
}

char *
GetLastFile(void){
	return(FILENAME?FILENAME:"");
}

void 
SvConfig(void)
{
   char s[100];
   Conf_save_callback_descr cbld[]=
   {
       {"WORK_MODE",GetWorkMode},	   
       {"SHOW_STANDARD_BAR",GetStdBar},
	   {"SHOW_TIME_BAR",GetTimeBar},	   
       {"LAST_WORK_FILE",GetLastFile},	   	   	   
	   {NULL,NULL}
   };
   sprintf(s,"%s/.gcrontab_options",g_get_home_dir());
   
   conf_Save(s,cbld);
   	
	
}



void 
RealQuit(void)
{
	SvConfig();
	gtk_main_quit();
}


void 
setcron                      (GtkButton       *button,
                                        gpointer         user_data)
{
	Set();
	if(CRONDIRTY){
		/*(FILENAME)*/
		   MsgDirty();		
		gtk_widget_destroy(GTK_WIDGET(user_data));		
	}else
		RealQuit();
}

void 
nosetcron                      (GtkButton       *button,
                                        gpointer         user_data)
{
	if(CRONDIRTY){
		/*if (FILENAME)*/
		   MsgDirty();	    
		gtk_widget_destroy(GTK_WIDGET(user_data));		
	}else
		RealQuit();
}

void
sv_close                       (GtkButton       *button,
                                        gpointer         user_data)
{
	g_print("%s ----",FILENAME);
   if(FILENAME){
	   SvCronFile();
       RealQuit();
   }else{
       win_sel=create_win_filesel(on_ok_button_save_quit_clicked,
		                     on_cancel_button1_clicked);	
       gtk_window_set_modal(GTK_WINDOW(win_sel),1);
       gtk_widget_show(GTK_WIDGET(win_sel));	   	  
   }
}

void
close_only                       (GtkButton       *button,
                                        gpointer         user_data)
{
   RealQuit();
}


void
MsgDirty(void)
{
	 GtkWidget *win_msg;
		   
  	 win_msg=msgbox_new("Warning !!!",NULL,"There are changes not saved.\nDo you want to save these changes ?","save.xpm",YES_BUTTON+NO_BUTTON);
     gtk_window_set_modal(GTK_WINDOW(win_msg),1);           
	 msgbox_button_signal_connect(win_msg,YES_BUTTON,sv_close);
	 msgbox_button_signal_connect(win_msg,NO_BUTTON,close_only);
     gtk_widget_show(win_msg);	
}

void 
Quit(void)
{   
	
	   if(SETDIRTY)
	   {
		   GtkWidget *win_msg;
		   win_msg=msgbox_new("Warning !!!",NULL,"This file is not set.\n Do you want to set it as your default file ?","exec.xpm",YES_BUTTON+NO_BUTTON);
           gtk_window_set_modal(GTK_WINDOW(win_msg),1);           
		   msgbox_button_signal_connect(win_msg,YES_BUTTON,setcron);
	       msgbox_button_signal_connect(win_msg,NO_BUTTON,nosetcron);	   
           gtk_widget_show(win_msg);			   
       }
	   else	   
          if(CRONDIRTY)	         
		       MsgDirty();
		  else
			   gtk_main_quit();
                       
}

void
on_quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   Quit();
}


void StdBarShow(void)
{
   GtkWidget *tbr;
   tbr=gtk_object_get_data(GTK_OBJECT(win_main), "handlebox4");         
	/*g_print("En stdbarshow %d",STDBAR);*/
   if(STDBAR)
      gtk_widget_show(tbr);      
   else   
      gtk_widget_hide(tbr);
      
}
void
on_stdbars_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   STDBAR=!STDBAR;   
   StdBarShow();         
}

void TimeBarShow(void)
{
   GtkWidget *tbr;
   tbr=gtk_object_get_data(GTK_OBJECT(win_main), "handlebox5");         
   if(TIMEBAR)
      gtk_widget_show(tbr);      
   else   	   
      gtk_widget_hide(tbr);      
      
}

void
on_timebar_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   TIMEBAR=!TIMEBAR;   
   TimeBarShow();      
}


void
on_hlp_activate                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   Help();
}


void About(void)
{
   Message("About gcrontab",
           "\ngcrontab ver 0.8.0\n\nA.L.Delgado 2000-2002\naldelgado@arquired.es\n    http://www.arquired.es/users/aldelgado/proy/gcrontab   \n\n",
	       "gcrontab.xpm");
}

void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   About();
}


void
on_btn_tbrnew_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   New();
}


void
on_btn_tbropen_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   Open();
}


void
on_btn_tbrsave_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   Save();
}


void
on_btn_tbradd_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   AddLine();
}


void
on_btn_tbrdel_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   DelLine();
}

void 
Help(void)
{
	help_Open(HTML_PAGES,PACKAGE_DATA_DIR "/help/C/gcrontab-DOC.000.html");
}

void
on_btn_tbrhelp_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   Help();
}


void
on_btn_tbrexit_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   Quit();
}


void
on_btn_minute_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(minute,0);        
}


void
on_btn_hour_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(hour,1);        
}


void
on_btn_dayofmonth_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(day,2);
}


void
on_btn_month_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(SIMPMODE?smmonth:month,3);
}


void
on_btn_dayofweek_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(SIMPMODE?smwday:wday,4);
}


void
on_btn_action_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowAction();
}


void
on_btn_calendar_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	  gpointer obj;	 
	  GDate *date;
	  /* gchar *sday,*smonth;*/
	
      if(GRDSELROW<=-1) return;
      win_cal=create_win_cal();
      gtk_window_set_modal(GTK_WINDOW(win_cal),1);           
      gtk_widget_show(win_cal);   

	  date=g_date_new();
	  g_date_set_time(date,time(NULL));

/*      gtk_clist_get_text(grd_cronln,i,2,sday);	  
      gtk_clist_get_text(grd_cronln,i,3,smonth);	  */
	  
      obj=gtk_object_get_data(GTK_OBJECT(win_cal), "cal_selday");		           
	  gtk_calendar_select_month(GTK_CALENDAR(obj),g_date_month(date)-1,g_date_year(date));
	  gtk_calendar_select_day(GTK_CALENDAR(obj),g_date_day(date));

}


void
on_grd_cron_select_row                 (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    GRDSELROW=row;   
}


void
on_grd_cron_unselect_row               (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
   GRDSELROW=-1;   
}


void 
ShowCitem(GList *l,int col)
{
    if(GRDSELROW<=-1) return;
    GRDSELCOL=col;
    
    win_citem = create_win_citem ();
	if(SIMPMODE){
           gpointer obj;
           obj=gtk_object_get_data(GTK_OBJECT(win_citem), "chk_step");		           
           gtk_widget_hide(obj);
           obj=gtk_object_get_data(GTK_OBJECT(win_citem), "sbt_step");		
           gtk_widget_hide(obj);           
	}
    gtk_window_set_modal(GTK_WINDOW(win_citem),1);                   
    initcmbs(l);        
    gtk_widget_show (win_citem);
}

void
ShowAction(void)
{
    if(GRDSELROW<=-1) return;
    GRDSELCOL=5;
     
    win_cmmd = create_dlg_command();
    gtk_window_set_modal(GTK_WINDOW(win_cmmd),1);                   
    gtk_widget_show (win_cmmd);                
}

void
on_grd_cron_click_column               (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
    if(column<5){
	   if(SIMPMODE)	
	      ShowCitem(smlsts[column],column);        
	   else
          ShowCitem(lsts[column],column);        
   }else
       ShowAction();

}


void
on_grd_cron_click_column_after         (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{

}



void 
AddLine (void)
{
      char *tpl[6];
      int i; 
      GtkCList *grd_cron;       

	  SETDIRTY=CRONDIRTY=1;
	
      grd_cron=gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron");        
      for(i=0;i<5;i++) tpl[i]=(char *)strdup("*");
      tpl[i]=(char *)strdup("None");
      
      gtk_clist_append(grd_cron,tpl);
	  StatusBarMsg("ShowAction(void) line added");
}


void
on_btn_addline_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   AddLine();
}


void
DelLine (void)
{
      GtkCList *grd_cron;       
      
      if(GRDSELROW>-1)
          {			
			  SETDIRTY=CRONDIRTY=1;
			  
              grd_cron=GTK_CLIST(gtk_object_get_data(GTK_OBJECT(win_main), "grd_cron"));        
              gtk_clist_remove (grd_cron, GRDSELROW);
			  StatusBarMsg("Line deleted");
          }

}

void
on_btn_delline_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   DelLine();
}


void
on_btn_xtra_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
   gchar *cmmd;
   GtkRadioButton *rbt;
   GtkEntry *edt;
    
   rbt=gtk_object_get_data(GTK_OBJECT(win_cmmd), "rbt_command");      
   if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rbt)))    
      {
          edt=gtk_object_get_data(GTK_OBJECT(win_cmmd), "edt_command");            
          cmmd=gtk_entry_get_text(edt);             
          
          system(cmmd);
      }
   else
      {
        win_sel=create_win_filesel(on_ok_button1_clicked,
		                           on_cancel_button1_clicked);
        gtk_window_set_modal(GTK_WINDOW(win_sel),1); 

        if(FILENAME) free(FILENAME);    
        gtk_widget_show (win_sel);              
      }
}


void
on_btn_acceptcmmd_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    gchar *txt;
    GtkEntry *edt_cmmd;
    
    edt_cmmd=gtk_object_get_data(GTK_OBJECT(win_cmmd), "edt_command");        
    txt=gtk_entry_get_text(edt_cmmd);
    
	SetGrdCron(GRDSELROW, 5, txt);
    gtk_widget_destroy(win_cmmd);    
}


void
on_btn_cancelcmd_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_destroy(win_cmmd);    
}


void
on_edt_text_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
   TXTDIRTY=1;
}


void
on_btn_close_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
FILE *pf;
   guint l;
   gchar *txt;
   GtkText *edt_text;
   struct stat buf;
   
   gtk_widget_hide(win_edit);
   if(TXTDIRTY)
      {
		   
           pf=fopen(FILENAME,"w");
           edt_text=gtk_object_get_data(GTK_OBJECT(win_edit), "edt_text");   
           l=gtk_text_get_length(edt_text);
           txt=gtk_editable_get_chars(GTK_EDITABLE(edt_text),0,l);
           fwrite(txt,1,l,pf);
           fclose(pf);           
           stat(FILENAME,&buf);
           chmod(FILENAME,(buf.st_mode)|S_IXUSR);
           free(FILENAME);
           free(txt);           
       }
   gtk_widget_destroy(win_edit);
}


void
on_ok_button1_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkEntry *edt_action;
  
  FILENAME=(char *)strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (win_sel)));
  
  
  gtk_widget_destroy(win_sel);
  
  edt_action=gtk_object_get_data(GTK_OBJECT(win_cmmd), "edt_command");   
  gtk_entry_set_text(edt_action,FILENAME);  
  EditFile(FILENAME, TRUE);  
}


void
on_cancel_button1_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
   FILENAME=NULL;
   gtk_widget_destroy(win_sel);   

}




void
on_cal_selday_day_selected             (GtkCalendar     *calendar,
                                        gpointer         user_data)
{
   
}


void
on_btn_okcal_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
   guint yy,mm,dd;
   gpointer cal;
   char aux[10],*auxp;
   
   cal=gtk_object_get_data(GTK_OBJECT(win_cal), "cal_selday");   
   gtk_calendar_get_date(GTK_CALENDAR(cal),&yy,&mm,&dd);
   
   sprintf(aux,"%d",dd);    
   auxp=(char*)strdup(aux);       
   SetGrdCron(GRDSELROW, 2, auxp);   
   
   auxp=(gpointer)g_list_nth_data(SIMPMODE?smmonth:month,mm);
   SetGrdCron(GRDSELROW, 3, auxp);   
   
   gtk_widget_destroy(win_cal);   
}


void
on_btn_cancelcal_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_destroy(win_cal);
}


void
on_simplified_mode_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if(SIMPMODE)
	   SIMPMODE=0;
	else
	   SIMPMODE=1;
}


void
on_crontab_man_page_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   help_Open(MAN_PAGES,"crontab");
}


void
on_druid_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{

    if(GRDSELROW<=-1) {
		Message("Warning !!!",
		"\n\n     Please,select a row first    \n\n","NULL");
	   return;	
	}
    win_druid=create_win_druid(); 
    gtk_window_set_modal(GTK_WINDOW(win_druid),1);           
    gtk_widget_show(win_druid);   	
}

void 
Set(void)
{
   char CMMD[255]="crontab ";	
   SETDIRTY=0;   
   
   if(FILENAME)
   {
	  Save();
      strcat(CMMD,FILENAME);
   }else{
	  SvCronFileNamed(TMPFILENAME,0);
      strcat(CMMD,TMPFILENAME);	   
   }
       
   g_print("%s-----\n",CMMD);
   system(CMMD);	  
   StatusBarMsg("Current file set as default crontab file");
   
}

void
on_set_current_file1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   Set();
}


void
on_remove_crontab1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   system("crontab -r");
}


void
on_btn_tbrset_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   Set();
}

void
on_save_geometry1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_open_sysfiles1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	char errmsg[255];

    if(!LdCronFile(getlogin(),0)) {
        sprintf(errmsg,"\n\n    Can't open cron  for %s.    \n\n",getlogin());	    
        Message("Warning !!",errmsg,NULL);
    }
}


void
on_btn_drdsetmin_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(minute,0);
}


void
on_btn_drdsethour_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(hour,1);
}


void
on_btn_drdanyhour_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    SetGrdCron(GRDSELROW, 1, "*");
}


void
on_btn_drdsetdayofmonth_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    ShowCitem(day,2);
		
    SetGrdCron(GRDSELROW, 4, "*");	
}


void
on_btn_drdsetdayofweek_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(SIMPMODE?smwday:wday,4);
   
   SetGrdCron(GRDSELROW, 2, "*");	
}


void
on_btn_drdanyday_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    SetGrdCron(GRDSELROW, 2, "*");
    SetGrdCron(GRDSELROW, 4, "*");
}


void
on_btn_drdsetmonth_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
   ShowCitem(SIMPMODE?smmonth:month,3);
}


void
on_btn_drdanymonth_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
    SetGrdCron(GRDSELROW, 3, "*");    
}


void
on_btn_prev_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *ntb;  

    ntb=gtk_object_get_data(GTK_OBJECT(win_druid), "ntb_druid");
	gtk_notebook_prev_page(GTK_NOTEBOOK(ntb));
}


void
on_btn_finish_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
   gtk_widget_hide(win_druid);
   gtk_widget_destroy(win_druid);
   ShowAction();
}


void
on_btn_next_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *ntb;  

    ntb=gtk_object_get_data(GTK_OBJECT(win_druid), "ntb_druid");
	gtk_notebook_next_page(GTK_NOTEBOOK(ntb));
}


void
on_ntb_druid_switch_page               (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
   /*g_print("%d !!!",page_num);*/
   if(page_num>=3){
	   GtkWidget *btn;  
	   
       btn=gtk_object_get_data(GTK_OBJECT(win_druid), "btn_finish");
	   gtk_widget_set_sensitive(btn,1);  
   }
   
}


void
newandget                       (GtkButton       *button,
                                        gpointer         user_data)
{
	LdSysCrontab();
	gtk_widget_destroy(GTK_WIDGET(user_data));
}


void 
GetCrontab(void)
{
		 GtkWidget *win_msg;
		   
  	 win_msg=msgbox_new("Warning !!!",NULL,"This action will destroy your job in this file\nAre you sure ?","refresh.xpm",YES_BUTTON+NO_BUTTON);
         gtk_window_set_modal(GTK_WINDOW(win_msg),1);           
 	 msgbox_button_signal_connect(win_msg,YES_BUTTON,newandget);
         gtk_widget_show(win_msg);	
}

void
on_get_current_file1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GetCrontab(); 	 
}


void
on_btn_refresh_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
   GetCrontab(); 	 
}

