package GCExport::GCExportBase;

###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use GCExportImport;

{
    package GCExport::GCExportBaseClass;

    use base 'GCExportImportBase';

    use File::Basename;
    use File::Copy;
    use GCUtils 'glob';
    
    #Methods to be overriden in specific classes
    
    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new;

        bless ($self, $class);
        return $self;
    }

    sub getSuffix
    {
        return '';
    }
    
    sub getModels
    {
        return [];
    }
    
    sub needsUTF8
    {
        return 0;
    }
    
    sub getOptions
    {
    }
    
    sub wantsDirectorySelection
    {
        return 0;
    }
    
    sub wantsFieldsSelection
    {
        return 0;
    }
    
    sub wantsImagesSelection
    {
        return 0;
    }
    
    sub wantsFileSelection
    {
        return 1;
    }
    
    sub getHeader
    {
    }

    sub getItem
    {
    }

    sub getFooter
    {
    }

    sub postProcess
    {
    }

    sub preProcess
    {
    }

    sub getEndInfo
    {
    }

    sub wantsOsSeparator
    {
        return 1;
    }    

    #End of methods to be overriden
    
    sub getUniqueImageFileName
    {
        my ($self, $suffix, $dir, $title) = @_;
        
        return $self->{options}->{parent}->getUniqueImageFileName($suffix, $title, $dir);
    }
    
    sub duplicatePicture
    {
        my ($self, $item, $field, $dir, $title) = @_;
        
        my $orig = $item->{$field};
        $self->{saved}->{$field} = $orig;
        my $newPic = $orig;
        if ($orig && $self->{options}->{withPictures})
        {
            $newPic = GCUtils::getDisplayedImage($orig,
                                                 $self->{options}->{defaultImage},
                                                 $self->{original});
            if ($newPic eq $self->{options}->{defaultImage})
            {
                $newPic = $self->{defaultImage};
            }
            else
            {
                (my $suffix = $newPic) =~ s/.*?(\.[^.]*)$/$1/;
                my $dest = $self->getUniqueImageFileName($suffix,
                                                         $dir,
                                                         $title);
                copy($newPic, $dest);
                $newPic = basename($dir).'/'.basename($dest);
            }
        }
        else
        {
            $newPic = basename($dir).'/'.basename($self->{options}->{defaultImage});
        }
        $newPic =~ s/\//\\/g if ($^O =~ /win32/i) && $self->wantsOsSeparator;
        return $newPic;
    }
    
    sub restorePicture
    {
        my $self = shift;
        return $self->{saved}->{image};
    }

    sub restoreInfo
    {
        my ($self, $info) = @_;

        foreach (keys %{$self->{saved}})
        {
            $info->{$_} = $self->{saved}->{$_};
        }
    }
    
    sub transformValue
    {
        my ($self, $value, $field) = @_;

        return $self->{options}->{originalList}->transformValue($value, $field);
    }
    
    # If you need really specific processing, you can instead override the process method
    sub process
    {
        my ($self, $options) = @_;

        $self->{saved} = {};

        $self->{options} = $options;

        $options->{file} .= $self->getSuffix
            if ($self->getSuffix) 
            && ($options->{file} !~ /\.\w*$/);
        $self->{fileName} = $options->{file};
        $self->{original} = $options->{collection};
        $self->{origDir} = dirname($self->{original});
        $options->{collectionDir} = $self->{origDir};

        ($self->{dirName} = $self->{fileName}) =~ s/\.[^.]*?$//;
        $self->{dirName} .= '_images';
        if ( -e $self->{dirName})
        {
            my @images = glob $self->{dirName}.'/*';
            unlink foreach (@images);
            rmdir $self->{dirName};
            unlink $self->{dirName} if ( -e $self->{dirName});
        }
        if ($self->{options}->{withPictures})
        {
            mkdir $self->{dirName};
            #Get a copy of default picture
            copy($self->{options}->{defaultImage},$self->{dirName});
            $self->{defaultImage} = basename($self->{dirName}).'/'
                                    .basename($self->{options}->{defaultImage});
       }

        $self->preProcess;

        my @tmpArray = @{$options->{items}};

        my $header = $self->getHeader($#tmpArray + 1);
        my $body = '';

        my $item;
        my $idx = 0;
        foreach $item(@tmpArray)
        {
            if ($self->{options}->{withPictures})
            {
                foreach my $pic(@{$self->{model}->{managedImages}})
                {
                    $item->{$pic} = $self->duplicatePicture($item, $pic, $self->{dirName},
                                                            $item->{$self->{model}->{commonFields}->{title}});
                }
            }

            $body .= $self->getItem($item, $idx);

            $self->restoreInfo($item);

	        $idx++;
        }
        my $footer = $self->getFooter($#tmpArray + 1);

        $self->postProcess(\$header, \$body);

        open EXPORTFILE, ">".$options->{file};
        binmode( EXPORTFILE, ':utf8') if $self->needsUTF8;
        print EXPORTFILE "$header";
        print EXPORTFILE "$body";
        print EXPORTFILE "$footer";
        close EXPORTFILE;

        return $self->getEndInfo;
    }
}

1;
