{
    package GCLang::EN;

    use utf8;
###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################
    
    use strict;
    use base 'Exporter';

    our @EXPORT = qw(%lang);

    our %lang = (

        'LangName' => 'English',
        
        'Separator' => ': ',
        
        'Warning' => '<b>Warning</b>:
        
Information downloaded from web sites (through the 
search plugins) is for <b>personal use only</b>.

Any redistribution is forbidden without the site\'s
<b>explicit authorization</b>.

To determine which site owns the information, you
may use the <b>button below item details</b>.',
        
        'AllItemsFiltered' => 'No item matches your filtering criteria',
        
#Installation
        'InstallDirInfo' => 'Installing in ',
        'InstallMandatory' => 'Mandatory components',
        'InstallOptional' => 'Optional Components',
        'InstallErrorMissing' => 'Error : Following Perl components have to be installed: ',
        'InstallPrompt' => 'Base directory for installation [/usr/local]: ',
        'InstallEnd' => 'End of the installation',
        'InstallNoError' => 'No error',
        'InstallLaunch' => 'To use this application, one can launch ',
        'InstallDirectory' => 'Base directory',
        'InstallTitle' => 'GCstar installation',
        'InstallDependencies' => 'Dependencies',
        'InstallPath' => 'Path',
        'InstallOptions' => 'Options',
        'InstallSelectDirectory' => 'Select base directory for the installation',
        'InstallWithClean' => 'Remove files found in installation directory',
        'InstallWithMenu' => 'Add GCstar to Applications menu',
        'InstallNoPermission' => 'Error: You don\'t have permission to write in the selected directory',
        'InstallMissingMandatory' => 'Mandatory dependencies are missing. You won\'t be able to install GCstar until they have been added to your system.',
        'InstallMissingOptional' => 'Some optional dependencies are missing. There are listed under. GCstar may be installed but some features won\'t be available.',
        'InstallMissingNone' => 'There are no missing dependency. You may continue and install GCstar.',
        'InstallOK' => 'OK',
        'InstallMissing' => 'Missing',
        'InstallMissingFor' => 'Missing for',
        'InstallCleanDirectory' => 'Removing GCstar\'s files in directory: ',
        'InstallCopyDirectory' => 'Copying files in directory: ',
        'InstallCopyDesktop' => 'Copying desktop file in: ',

#Update
        'UpdateUseProxy' => 'Proxy to use (just press enter if none): ',
        'UpdateNoPermission' => 'Write permission denied in this directory: ',
        'UpdateNone' => 'No update have been found',
        'UpdateFileNotFound' => 'File not found',

#Splash
        'SplashInit' => 'Initialization',
        'SplashLoad' => 'Loading Collection',
        'SplashDisplay' => 'Displaying Collection',
        'SplashDone' => 'Ready',

#Import from GCfilms
        'GCfilmsImportQuestion' => 'It seems you were using GCfilms before. What do you want to import from GCfilms to GCstar (it won\'t impact GCfilms if you still want to use it)?',
        'GCfilmsImportOptions' => 'Settings',
        'GCfilmsImportData' => 'Movies list',

#Menus
        'MenuFile' => '_File',
            'MenuNewList' => '_New Collection',
            'MenuHistory' => '_Recent Collections',
            'MenuLend' => 'Display _Borrowed Items',
            'MenuImport' => '_Import',	
            'MenuExport' => '_Export',
    
        'MenuEdit'  => '_Edit',
            'MenuDuplicate' => 'Du_plicate item',
            'MenuEditDeleteCurrent' => '_Remove item',
            'MenuEditFields' => '_Change collection fields',
            'MenuEditLockItems' => '_Lock Collection',
    
        'MenuDisplay' => 'F_ilter',
            'MenuAdvancedSearch' => 'A_dvanced Search',
            'MenuViewAllItems' => 'Show _All items',
            'MenuNoFilter' => '_Any',
    
        'MenuConfiguration' => '_Settings',
            'MenuDisplayOptions' => '_Displayed Information',
            'MenuBorrowers' => '_Borrowers',
            'MenuGenresConversion' => 'Genre _Conversion',
        
        'MenuBookmarks' => 'My _Collections',
            'MenuBookmarksAdd' => '_Add current collection',
            'MenuBookmarksEdit' => '_Edit bookmarked collections',

        'MenuHelp' => '_Help',
            'MenuHelpContent' => '_Content',
            'MenuAllPlugins' => 'View _plugins',
            'MenuBugReport' => 'Report a _bug',
            'MenuAbout' => '_About GCstar',
    
        'MenuNewWindow' => 'Show item in _New Window',
        
        'ContextExpandAll' => 'Expand all',
        'ContextCollapseAll' => 'Collapse all',
        
        'DialogEnterNumber' => 'Please enter value',

        'RemoveConfirm' => 'Do you really want to remove this item?',
        'DefaultNewItem' => 'New item',
        'NewItemTooltip' => 'Add a new item',
        'NoItemFound' => 'Nothing was found. Would you like to search another site?',
        'OpenList' => 'Please select collection',
        'SaveList' => 'Please choose where to save the collection',
        'SaveListTooltip' => 'Save current collection',
        'SaveCurrentList' => 'First specify where to save the current collection',
        'SaveUnsavedChanges' => 'There are unsaved changes in your collection. Do you want to save them?',
        'SaveDontSave' => 'Don\'t save',
        'PreferencesTooltip' => 'Set your preferences',
        'ViewTooltip' => 'Change collection display',
        'PlayTooltip' => 'Play video associated to the item',

        'StatusSave' => 'Saving...',
        'StatusLoad' => 'Loading...',
        'StatusSearch' => 'Search in progress...',
        'StatusGetInfo' => 'Getting information...',
        'StatusGetImage' => 'Getting picture...',
                
        'SaveError' => 'Cannot save items list. Please check access rights and disk free space.',
        'OpenError' => 'Cannot open items list. Please check access rights.',
		'OpenFormatError' => 'Cannot open items list. Format may be incorrect.',
        'ImageError' => 'Selected directory to save images is not correct. Please select another one.',
        'OptionsCreationError'=> 'Cannot create options file: ',
        'OptionsOpenError'=> 'Cannot open options file: ',
        'OptionsSaveError'=> 'Cannot save options file: ',
        
        'RandomTooltip' => 'What to see this evening ?',
        'RandomError'=> 'You have no item that could be selected',
        'RandomEnd'=> 'There are no more items',
        'RandomNextTip'=> 'Next suggestion',
        'RandomOkTip'=> 'Accept this item',
        
        'AboutTitle' => 'About GCstar',
        'AboutDesc' => 'Collection manager',
        'AboutVersion' => 'Version',
        'AboutTeam' => 'Team',
        'AboutWho' => 'Tian: Project manager, Programmer
Adolfo González : Programmer',
        'AboutLicense' => 'Distributed under the terms of the GNU GPL
Logos Copyright le Spektre
http://le-spektre.org',
        'AboutTranslation' => 'English translation by Tian and Jason Day',
        'AboutDesign' => 'Logo and webdesign by le Spektre',

        'ToolbarRandom' => 'Tonight',

        'ModelsSelect' => 'Select a collection type',
        'ModelsPersonal' => 'Personal models',
        'ModelsDefault' => 'Default models',
        'ModelsList' => 'Collection definition',
        'ModelSettings' => 'Collection settings',
        'ModelNewType' => 'New collection type',
        'ModelName' => 'Name of the collection type:',
        'ModelNewField' => 'New field',
        'ModelFieldInformation' => 'Information',
        'ModelFieldName' => 'Label:',
        'ModelFieldType' => 'Type:',
        'ModelFieldGroup' => 'Group:',
        'ModelFieldValues' => 'Values',
        'ModelFieldInit' => 'Default:',
        'ModelFieldMin' => 'Minimum:',
        'ModelFieldMax' => 'Maximum:',
        'ModelFieldList' => 'Values list:',
        'ModelFieldListLegend' => '<i>Comma separated</i>',
        'ModelFieldTypeShortText' => 'Short text',
        'ModelFieldTypeLongText' => 'Long text',
        'ModelFieldTypeYesNo' => 'Yes/No',
        'ModelFieldTypeNumber' => 'Number',
        'ModelFieldTypeDate' => 'Date',
        'ModelFieldTypeOptions' => 'Pre-defined values list',
        'ModelFieldTypeImage' => 'Image',
        'ModelFieldTypeSingleList' => 'Simple list',
        'ModelFieldTypeFile' => 'File',
        'ModelFieldParameters' => 'Parameters',
        'ModelFieldHasHistory' => 'Use an history',
        'ModelFieldFlat' => 'Display on one line',
        'ModelFieldStep' => 'Increment step:',
        'ModelFieldFileFormat' => 'File format:',
        'ModelFieldFileFile' => 'Simple file',
        'ModelFieldFileImage' => 'Image',
        'ModelFieldFileVideo' => 'Video',
        'ModelFieldFileAudio' => 'Audio',
        'ModelFieldFileProgram' => 'Program',
        'ModelFieldFileUrl' => 'URL',
        'ModelOptionsFields' => 'Fields to use',
        'ModelOptionsFieldsAuto' => 'Automatic',
        'ModelOptionsFieldsNone' => 'None',
        'ModelOptionsFieldsTitle' => 'As title',
        'ModelOptionsFieldsId' => 'As identifier',
        'ModelOptionsFieldsCover' => 'As cover',
        'ModelOptionsFieldsPlay' => 'For Play button',
        'ModelCollectionSettings' => 'Collection settings',
        'ModelCollectionSettingsLending' => 'Items could be borrowed',
        'ModelFilterActivated' => 'Should be in search box',
        'ModelFilterComparison' => 'Comparison',
        'ModelFilterContain' => 'Contains',
        'ModelFilterRange' => 'Range',
        'ModelFilterNumeric' => 'Comparison is numeric',
        'ModelFilterQuick' => 'Create a quick filter',
        'ModelTooltipName' => 'Use a name to re-use this model for many collections. If empty, the settings will be directly stored in the collection itself',
        'ModelTooltipLabel' => 'The field name as it will be displayed',
        'ModelTooltipGroup' => 'Used to group fields. Items with no value here will be in a default group',
        'ModelTooltipHistory' => 'Should the previous entered values be stored in a list associated to the field',
        'ModelTooltipFormat' => 'This format is used to determine the action to open the file with the Play button',
        'ModelTooltipLending' => 'This will add some fields to manage lendings',
        'ModelTooltipNumeric' => 'Should the values be consider as numbers for comparison',
        'ModelTooltipQuick' => 'This will add a submenu in the Filters one',
        
        'ResultsTitle' => 'Select an item',
        'ResultsNextTip' => 'Search in next site',
        'ResultsPreview' => 'Preview',
        
        'OptionsTitle' => 'Preferences',
        'OptionsBrowser' => 'Web browser',
        'OptionsPlayer' => 'Video player',
        'OptionsAudio' => 'Audio player',
        'OptionsImages' => 'Images directory',
        'OptionsUseRelativePaths' => 'Use relative paths for images',
        'OptionsLayout' => 'Layout',
        'OptionsStatus' => 'Display status bar',
        'OptionsWarning' => 'Warning: Changes in this tab won\'t take effect until the application is restarted.',
        'OptionsRemoveConfirm' => 'Ask confirmation before item deletion',
        'OptionsAutoSave' => 'Automatically save collection',
        'OptionsAutoLoad' => 'Load previous collection on startup',
        'OptionsSplash' => 'Show splash screen',
        'OptionsImagesTitle' => 'Select a directory',
        'OptionsProgramTitle' => 'Select the program to be used',
		'OptionsPlugins' => 'Site to retrieve data from',
		'OptionsAskPlugins' => 'Ask (All sites)',
		'OptionsPluginsMulti' => 'Many sites',
		'OptionsPluginsMultiAsk' => 'Ask (Many sites)',
		'OptionsPluginsList' => 'Set list',
        'OptionsAskImport' => 'Select fields to be imported',
		'OptionsProxy' => 'Use a proxy',
        'OptionsLang' => 'Language',
        'OptionsMain' => 'Main',
        'OptionsPaths' => 'Paths',
        'OptionsInternet' => 'Internet',
        'OptionsConveniences' => 'Features',
        'OptionsDisplay' => 'Display',
        'OptionsToolbar' => 'Toolbar',
        'OptionsToolbars' => {0 => 'None', 1 => 'Small', 2 => 'Large'},
        'OptionsToolbarPosition' => 'Position',
        'OptionsToolbarPositions' => {0 => 'Top', 1 => 'Bottom', 2 => 'Left', 3 => 'Right'},
        'OptionsView' => 'Items list',
        'OptionsViews' => {0 => 'Text', 1 => 'Image', 2 => 'Detailed'},
        'OptionsColumns' => 'Columns',
        'OptionsMailer' => 'E-mailer',
        'OptionsSMTP' => 'Server',
        'OptionsFrom' => 'Your e-mail',
        'OptionsTransform' => 'Place articles at the end of titles',
        'OptionsArticles' => 'Articles (Comma separated)',
        'OptionsSearchStop' => 'Allow search to be aborted',
        'OptionsAlwaysOriginal' => 'Use main title as the original title if none present',
        'OptionsHistory' => 'Size of history',
        'OptionsClearHistory' => 'Clear history',
		'OptionsStyle' => 'Skin',
        'OptionsDontAsk' => 'Don\'t ask anymore',
        'OptionsPathProgramsGroup' => 'Applications',
        'OptionsPathImagesGroup' => 'Images',
        'OptionsInternetDataGroup' => 'Data import',
        'OptionsInternetSettingsGroup' => 'Settings',
        'OptionsDisplayInformationGroup' => 'Information display',
        'OptionsDisplayArticlesGroup' => 'Articles',
        'OptionsImagesDisplayGroup' => 'Display',
        'OptionsImagesStyleGroup' => 'Style',
        'OptionsDetailedPreferencesGroup' => 'Preferences',
        'OptionsFeaturesConveniencesGroup' => 'Conveniences',
        'OptionsPicturesFormat' => 'Prefix to use for pictures:',
        'OptionsPicturesFormatInternal' => 'gcstar__',
        'OptionsPicturesFormatTitle' => 'Title or name of the associated item',
        'OptionsConfigureMailers' => 'Configure mailing programs',

        'ImagesOptionsButton' => 'Settings',
        'ImagesOptionsTitle' => 'Settings for images list',
        'ImagesOptionsSelectColor' => 'Select a color',
        'ImagesOptionsBg' => 'Background',
        'ImagesOptionsBgPicture' => 'Use a background picture',
        'ImagesOptionsFg'=> 'Selection',
        'ImagesOptionsBgTooltip' => 'Change background color',
        'ImagesOptionsFgTooltip'=> 'Change selection color',
        'ImagesOptionsSizeLabel' => 'Size',
        'ImagesOptionsSizeList' => {0 => 'Very Small', 1 => 'Small', 2 => 'Medium', 3 => 'Large', 4 => 'Extra Large'},
        'ImagesOptionsSizeTooltip' => 'Select image size',
		        
        'DetailedOptionsTitle' => 'Settings for detailed list',
        'DetailedOptionsImageSize' => 'Images size',
        'DetailedOptionsGroupItems' => 'Group items by',
		'DetailedOptionsFields' => 'Select fields to display',
		'DetailedOptionsMasterOption' => 'Group master is',
		'DetailedOptionsMasterGenerated' => 'Auto generated',
		'DetailedOptionsMasterOrdered' => 'Determined by',

        'ExtractButton' => 'Information',
        'ExtractTitle' => 'File information',
        'ExtractImport' => 'Use values',

        'FieldsListOpen' => 'Load a fields list from a file',
        'FieldsListSave' => 'Save fields list to a file',
        'FieldsListError' => 'This fields list cannot be used with this kind of collection',

        'ExportTitle' => 'Export item list',
        'ExportFilter' => 'Export only displayed items',
        'ExportFieldsTitle' => 'Fields to be exported',
        'ExportFieldsTip' => 'Select fields you want to export',
        'ExportWithPictures' => 'Copy pictures in a sub-directory',

        'ImportListTitle' => 'Import another items list',
        'ImportExportData' => 'Data',
        'ImportExportFile' => 'File',
        'ImportExportSave' => 'Please select file to use',
        'ImportExportFieldsUnused' => 'Unused fields',
        'ImportExportFieldsUsed' => 'Used fields',
        'ImportExportFieldsFill' => 'Add All',
        'ImportExportFieldsClear' => 'Remove All',
        'ImportExportFieldsEmpty' => 'You must choose at least one field',
        'ImportExportFileEmpty' => 'You have to specify a file name',
        'ImportFieldsTitle' => 'Fields to be imported',
        'ImportFieldsTip' => 'Select fields you want to import',
        'ImportNewList' => 'Create a new collection',
        'ImportCurrentList' => 'Add to current collection',
        'ImportDropError' => 'There was an error opening at least one file. Previous list will be reloaded.',

        'FileOverwrite' => 'This file already exists. Do you want to overwrite it?',

        #Some default panels
        'PanelCompact' => 'Compact',
        'PanelReadOnly' => 'Read Only',
        'PanelForm' => 'Tabs',

        'PanelSearchButton' => 'Fetch Information',
        'PanelSearchTip' => 'Search web for information on this name',
        'PanelImageTipOpen' => 'Click on the picture to select different one.',
        'PanelImageTipView' => 'Click on the picture to view it in real size.',
        'PanelImageTipMenu' => ' Right click for more options.',
        'PanelImageTitle' => 'Select a picture',
        'PanelImageNoImage' => 'No image',
        'PanelSelectFileTitle' => 'Select a file',

        'PanelFrom' =>'From',
        'PanelTo' =>'To',

        'PanelWeb' => 'View Information',
        'PanelWebTip' => 'View information on the web about this item',
        'PanelRemoveTip' => 'Remove current item',

        'PanelDateSelect' => 'Select a Date',
        'PanelNobody' => 'Nobody',
        'PanelUnknown' => 'Unknown',

        'PanelLending' => 'Lending',
        'PanelBorrower' => 'Borrower',
        'PanelLendDate' => 'Out Since',
        'PanelHistory' => 'Lending History',
        'PanelReturned' => 'Item Returned',
        'PanelReturnDate' => 'Return date',
        'PanelLendedYes' => 'Lended',
        'PanelLendedNo' => 'Available',

        'CheckUndef' => 'Either',
        'CheckYes' => 'Yes',
        'CheckNo' => 'No',

        'ToolbarAll' => 'View All',
        'ToolbarAllTooltip' => 'View all items',
        'ToolbarGroupBy' => 'Group by',
        'ToolbarGroupByTooltip' => 'Select the field to use to group items in list',
        
        'PluginsTitle' => 'Search an item',
        'PluginsQuery' => 'Query',
        'PluginsFrame' => 'Search site',
        'PluginsLogo' => 'Logo',
        'PluginsName' => 'Name',
        'PluginsSearchFields' => 'Search fields',
        'PluginsAuthor' => 'Author',
        'PluginsLang' => 'Language',
        'PluginsUseSite' => 'Use selected site for future searches',

        'BorrowersTitle' => 'Borrower Configuration',
        'BorrowersList' => 'Borrowers',
        'BorrowersName' => 'Name',
        'BorrowersEmail' => 'E-mail',
        'BorrowersAdd' => 'Add',
        'BorrowersRemove' => 'Remove',
        'BorrowersEdit' => 'Edit',
        'BorrowersTemplate' => 'Mail template',
        'BorrowersSubject' => 'Mail subject',
        'BorrowersNotice1' => '%1 will be replaced with the borrower\'s name',
        'BorrowersNotice2' => '%2 will be replaced with the item title',
        'BorrowersNotice3' => '%3 will be replaced with the borrow date',

        'BorrowersImportTitle' => 'Import borrowers information',
        'BorrowersImportType' => 'File format:',
        'BorrowersImportFile' => 'File:',

        'BorrowedTitle' => 'Borrowed items',
        'BorrowedDate' => 'Since',

        'MailTitle' => 'Send an e-mail',
        'MailFrom' => 'From: ',
        'MailTo' => 'To: ',
        'MailSubject' => 'Subject: ',
        'MailSmtpError' => 'Problem when connecting to SMTP server',
        'MailSendmailError' => 'Problem when launching sendmail',

        'SearchTooltip' => 'Search all items',
        'SearchTitle' => 'Item Search',

        'QueryReplaceField' => 'Field to replace',
        'QueryReplaceOld' => 'Current value',
        'QueryReplaceNew' => 'New value',
        'QueryReplaceLaunch' => 'Replace',
        
        'ImportWindowTitle' => 'Select Fields to be Imported',
        'ImportViewPicture' => 'View picture',
        'ImportSelectAll' => 'Select all',
        'ImportSelectNone' => 'Select none',

        'MultiSiteTitle' => 'Sites to use for searches',
        'MultiSiteUnused' => 'Unused plugins',
        'MultiSiteUsed' => 'Plugins to be used',
        'MultiSiteLang' => 'Fill list with English plugins',
        'MultiSiteEmptyError' => 'You have an empty site list',
        'MultiSiteClear' => 'Clear list',
        
        'DisplayOptionsTitle' => 'Items to display',
        'DisplayOptionsAll' => 'Select all',
        'DisplayOptionsSearch' => 'Search button',

        'GenresTitle' => 'Genre Conversion',
        'GenresCategoryName' => 'Genre to use',
        'GenresCategoryMembers' => 'Genre to replace',
        'GenresLoad' => 'Load a list',
        'GenresExport' => 'Save list to a file',
        'GenresModify' => 'Edit conversion',

        'PropertiesName' => 'Collection name',
        'PropertiesOwner' => 'Owner',
        'PropertiesEmail' => 'Email',
        'PropertiesDescription' => 'Description',
        'PropertiesFile' => 'File Information',
        'PropertiesFilePath' => 'Full path',
        'PropertiesItemsNumber' => 'Number of items',
        'PropertiesFileSize' => 'Size',
        'PropertiesFileSizeSymbols' => ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
        'PropertiesCollection' => 'Collection properties',

        'MailProgramsTitle' => 'Programs for mail sending',
        'MailProgramsName' => 'Name',
        'MailProgramsCommand' => 'Command line',
        'MailProgramsRestore' => 'Restore defaults',
        'MailProgramsAdd' => 'Add a program',
        'MailProgramsInstructions' => 'In command line, some substitutions are made:
 %f is replaced with user\'s e-mail address.
 %t is replaced with the recipient address.
 %s is replaced with the subject of the message.
 %b is replaced with the body of the message.',

        'BookmarksBookmarks' => 'Bookmarks',
        'BookmarksFolder' => 'Folders',
        'BookmarksLabel' => 'Label',
        'BookmarksPath' => 'Path',
        'BookmarksNewFolder' => 'New folder',

        'AdvancedSearchType' => 'Type of search',
        'AdvancedSearchTypeAnd' => 'Items matching all criteria',
        'AdvancedSearchTypeOr' => 'Items matching at least one criterion',
        'AdvancedSearchCriteria' => 'Criteria',
 
    );
}
1;
