/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

// CvsAlert.cpp : implementation file
//

#include "stdafx.h"

#ifdef macintosh
#	define kDlgIdAlert 129
#	include <Dialogs.h>
#	include <TextUtils.h>
#	include <string.h>
#	include "MacMisc.h"
#endif /* macintosh */

#if qUnix
#	include "UCvsDialogs.h"
#endif

#ifdef WIN32
#	include "resource.h"

#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

#include "CvsAlert.h"

#ifdef WIN32
/////////////////////////////////////////////////////////////////////////////
// CCVSAlert dialog


CCVSAlert::CCVSAlert(const char *prompt, const char *defhit, const char *cnclhit,
					 CWnd* pParent /*=NULL*/)
	: CDialog(CCVSAlert::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCVSAlert)
	m_prompt = prompt != NULL ? prompt : "";
	m_cnclhit = cnclhit != NULL ? cnclhit : "";
	m_defhit = defhit != NULL ? defhit : "";
	//}}AFX_DATA_INIT
}


void CCVSAlert::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCVSAlert)
	DDX_Text(pDX, IDC_ALRTMSG, m_prompt);
	DDX_Text(pDX, IDCANCEL, m_cnclhit);
	DDX_Text(pDX, IDOK, m_defhit);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCVSAlert, CDialog)
	//{{AFX_MSG_MAP(CCVSAlert)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCVSAlert message handlers
#endif /* WIN32 */

#ifdef macintosh
	static const char *sPrompt = 0L, *sDefhit = 0L, *sCnclhit = 0L;
	
	static pascal Boolean AlertModalFilter(DialogPtr dlog, EventRecord *event, short *itemHit)
	{
		DialogPtr evtDlog;
		short selStart,selEnd;

		if (event->what == activateEvt && (event->modifiers & activeFlag) != 0)
		{
			Str255 pp, pd, pc;
			c2pstrcpy(pp, sPrompt);
			c2pstrcpy(pd, sDefhit);
			c2pstrcpy(pc, sCnclhit);
			
			SetControlTitle(GetDItemCtrlHdl(dlog, 1), pd);
			SetControlTitle(GetDItemCtrlHdl(dlog, 2), pc);
			SetDialogItemText(GetDItemHdl(dlog, 3), pp);
		}

		return false;		   // For all non-keyDown events
	}
#endif /* macintosh */

#if qUnix
class UAskYesNo : public UWidget
{
	UDECLARE_DYNAMIC(UAskYesNo)
public:
	UAskYesNo() : UWidget(::UEventGetWidID()) {}
	virtual ~UAskYesNo() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kText					// 2
	};
	
protected:
	ev_msg int OnOK(void);
	ev_msg int OnCancel(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UAskYesNo, UWidget)

UBEGIN_MESSAGE_MAP(UAskYesNo, UWidget)
	ON_UCOMMAND(UAskYesNo::kOK, UAskYesNo::OnOK)
	ON_UCOMMAND(UAskYesNo::kCancel, UAskYesNo::OnCancel)
UEND_MESSAGE_MAP()

int UAskYesNo::OnOK(void)
{
	EndModal(true);
	return 0;
}

int UAskYesNo::OnCancel(void)
{
	EndModal(false);
	return 0;
}
#endif

bool CvsAlert(const char *prompt, const char *defhit, const char *cnclhit)
{
#ifdef WIN32
	CCVSAlert gv(prompt, defhit, cnclhit);
	return gv.DoModal() == IDOK;
#endif /* WIN32 */
#ifdef macintosh
	static ModalFilterUPP filter = NULL;
	
	if(filter == NULL)
		filter = NewModalFilterUPP(AlertModalFilter);
	
	sPrompt = prompt;
	sDefhit = defhit;
	sCnclhit = cnclhit;
	
	return CautionAlert(kDlgIdAlert, filter) == 1;
#endif /* macintosh */
#if qUnix
	void *wid = UCreate_AskYesNo();

	UAskYesNo *dlg = new UAskYesNo();
	UEventSendMessage(dlg->GetWidID(), EV_INIT_WIDGET, kUMainWidget, wid);
	UEventSendMessage(dlg->GetWidID(), EV_SETTEXT, kUMainWidget, (void *)"Alert");
	UEventSendMessage(dlg->GetWidID(), EV_SETTEXT, UAskYesNo::kOK, (void *)defhit);
	UEventSendMessage(dlg->GetWidID(), EV_SETTEXT, UAskYesNo::kCancel, (void *)cnclhit);
	UEventSendMessage(dlg->GetWidID(), EV_SETTEXT, UAskYesNo::kText, (void *)prompt);

	bool res = dlg->DoModal();
	delete dlg;
	return res;
#endif
}
