/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import ch.interlis.ili2c.generator.IndentPrintWriter;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.BasketType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.ErrorListener;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public final class Gml32Generator {
    IndentPrintWriter ipw;
    TransferDescription td;
    String outdir;
    ErrorListener el;
    int numErrors = 0;
    private static String PRBLMTAG = "preGML32:";
    static ResourceBundle rsrc;
    private HashSet lineAttrs = new HashSet();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.interlis.ili2c.generator.Interlis1Generator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        rsrc = ResourceBundle.getBundle(clazz.getName(), Locale.getDefault());
    }

    private Gml32Generator(TransferDescription td, String outdir, ErrorListener el) {
        this.td = td;
        this.outdir = outdir;
        this.el = el;
    }

    public static int generate(TransferDescription td, String outdir, ErrorListener el) {
        Gml32Generator d = new Gml32Generator(td, outdir, el);
        d.printXSD(td);
        return d.numErrors;
    }

    private static String getTransferName(Element elt) {
        if (elt instanceof Model) {
            return elt.getName();
        }
        if (elt instanceof Topic) {
            return elt.getScopedName(null);
        }
        if (elt instanceof Viewable) {
            return elt.getScopedName(null);
        }
        if (elt instanceof Domain) {
            return elt.getScopedName(null);
        }
        if (elt instanceof AttributeDef) {
            return elt.getName();
        }
        if (elt instanceof RoleDef) {
            return elt.getName();
        }
        throw new IllegalArgumentException();
    }

    private void printXSD(TransferDescription td) {
        Iterator modeli = td.iterator();
        while (modeli.hasNext()) {
            Object mObj = modeli.next();
            if (!(mObj instanceof Model) || mObj instanceof PredefinedModel) continue;
            Model model = (Model)mObj;
            String filename = String.valueOf(this.outdir) + "/" + model.getName() + ".xsd";
            try {
                this.ipw = new IndentPrintWriter(new BufferedWriter(new FileWriter(filename)));
            }
            catch (IOException ex) {
                this.el.error(new ErrorListener.ErrorEvent(ex, null, 0, 5));
                return;
            }
            this.ipw.println("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
            this.ipw.indent();
            this.ipw.println("xmlns=\"http://www.interlis.ch/INTERLIS2.2/preGML32\" targetNamespace=\"http://www.interlis.ch/INTERLIS2.2/preGML32\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\"");
            this.ipw.println("xmlns:gml=\"http://www.opengis.net/gml\"");
            this.ipw.println(">");
            this.ipw.unindent();
            this.ipw.println("<xsd:import namespace=\"http://www.opengis.net/gml\"/>");
            Iterator topici = model.iterator();
            while (topici.hasNext()) {
                Object tObj = topici.next();
                if (tObj instanceof Domain) {
                    this.declareDomainDef((Domain)tObj);
                }
                if (tObj instanceof AbstractClassDef) {
                    this.declareAbstractClassDef((AbstractClassDef)tObj);
                }
                if (tObj instanceof LineForm) {
                    this.declareLineForm((LineForm)tObj);
                }
                if (!(tObj instanceof Topic)) continue;
                Topic topic = (Topic)tObj;
                this.declareTopic(topic);
            }
            this.declareCurveSegmentWithLineAttr();
            this.ipw.println("</xsd:schema>");
            this.ipw.close();
        }
    }

    private boolean suppressModel(Model model) {
        if (model == null) {
            return true;
        }
        if (model == this.td.INTERLIS) {
            return true;
        }
        return model instanceof TypeModel || model instanceof PredefinedModel;
    }

    private boolean suppressTopic(Topic topic) {
        if (topic == null) {
            return true;
        }
        return topic.isAbstract();
    }

    private boolean suppressTopicInAliasTable(Topic topic) {
        return this.suppressTopic(topic);
    }

    private boolean suppressViewable(Viewable v) {
        if (v == null) {
            return true;
        }
        if (v.isAbstract()) {
            return true;
        }
        if (v instanceof AssociationDef && ((AssociationDef)v).isLightweight()) {
            return true;
        }
        if (v instanceof View) {
            Topic topic;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("ch.interlis.ili2c.metamodel.Topic");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((topic = (Topic)v.getContainer(clazz)) != null && !topic.isViewTopic()) {
                return true;
            }
        }
        return v instanceof Table && !((Table)v).isIdentifiable();
    }

    private boolean suppressViewableInAliasTable(Viewable v) {
        if (v == null) {
            return true;
        }
        if (v.isAbstract()) {
            return true;
        }
        if (v instanceof View) {
            Topic topic;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("ch.interlis.ili2c.metamodel.Topic");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((topic = (Topic)v.getContainer(clazz)) != null && !topic.isViewTopic()) {
                return true;
            }
        }
        return false;
    }

    private void declareTopic(Topic topic) {
        Object obj;
        Iterator iter = topic.iterator();
        while (iter.hasNext()) {
            obj = iter.next();
            if (obj instanceof Domain) {
                this.declareDomainDef((Domain)obj);
            }
            if (!(obj instanceof AbstractClassDef)) continue;
            this.declareAbstractClassDef((AbstractClassDef)obj);
        }
        this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(topic) + ".member\" type=\"" + Gml32Generator.getTransferName(topic) + ".member\" substitutionGroup=\"gml:abstractFeatureMember\"/>");
        this.ipw.println("<xsd:complexType name=\"" + Gml32Generator.getTransferName(topic) + ".member\">");
        this.ipw.indent();
        this.ipw.println("<xsd:complexContent>");
        this.ipw.indent();
        this.ipw.println("<xsd:extension base=\"gml:AbstractFeatureMemberType\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:choice>");
        this.ipw.indent();
        iter = topic.getViewables().iterator();
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof Viewable) || this.suppressViewable((Viewable)obj)) continue;
            Viewable v = (Viewable)obj;
            this.ipw.println("<xsd:element ref=\"" + Gml32Generator.getTransferName(v) + "\"/>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:choice>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:extension>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexContent>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(topic) + "\" type=\"" + Gml32Generator.getTransferName(topic) + "\" substitutionGroup=\"gml:_GML\"/>");
        this.ipw.println("<xsd:complexType name=\"" + Gml32Generator.getTransferName(topic) + "\">");
        this.ipw.indent();
        this.ipw.println("<xsd:complexContent>");
        this.ipw.indent();
        this.ipw.println("<xsd:extension base=\"gml:AbstractGMLType\">");
        this.ipw.indent();
        Topic baseType = (Topic)topic.getExtending();
        if (baseType != null) {
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express extension of topic -->");
        }
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(topic) + ".member\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:extension>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexContent>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    private void declareAbstractClassDef(Viewable v) {
        String baseElement = "gml:_Feature";
        Viewable baseType = (Viewable)v.getExtending();
        if (baseType != null) {
            baseElement = Gml32Generator.getTransferName(baseType);
        }
        this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(v) + "\" type=\"" + Gml32Generator.getTransferName(v) + "\" substitutionGroup=\"" + baseElement + "\"/>");
        this.ipw.println("<xsd:complexType  name=\"" + Gml32Generator.getTransferName(v) + "\">");
        this.ipw.indent();
        this.ipw.println("<xsd:complexContent>");
        this.ipw.indent();
        String baseXsdType = "gml:AbstractFeatureType";
        if (baseType != null) {
            baseXsdType = Gml32Generator.getTransferName(baseType);
        }
        this.ipw.println("<xsd:extension base=\"" + baseXsdType + "\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            AttributeDef attr;
            Object obj = iter.next();
            if (obj instanceof AttributeDef && (attr = (AttributeDef)obj).getExtending() == null) {
                this.declareAttribute(attr);
            }
            if (!(obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj;
            if (this.isLightweightAssociation((AssociationDef)v)) continue;
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(role) + "\" type=\"gml:ReferenceType\">");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express target type -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express ordering kind -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express aggregation kind -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express cardinality -->");
            this.ipw.println("</xsd:element>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:extension>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexContent>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    private boolean isLightweightAssociation(AssociationDef v) {
        return false;
    }

    private void declareDomainDef(Domain domain) {
        Type type = domain.getType();
        this.declareType(type, domain);
    }

    private void declareAttribute(AttributeDef attribute) {
        Type type;
        String minOccurs = "";
        if (!attribute.getDomain().isMandatoryConsideringAliases()) {
            minOccurs = " minOccurs=\"0\"";
        }
        if ((type = attribute.getDomain()) instanceof TypeAlias) {
            Domain realDomain = ((TypeAlias)type).getAliasing();
            Type realType = realDomain.getType();
            if (realDomain == this.td.INTERLIS.BOOLEAN) {
                this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\" type=\"xsd:boolean\"" + minOccurs + "/>");
            } else {
                this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\" type=\"" + Gml32Generator.getTransferName(((TypeAlias)type).getAliasing()) + "\"" + minOccurs + "/>");
            }
        } else if (type instanceof CoordType) {
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\"" + minOccurs + " type=\"gml:PointPropertyType\"" + ">");
            this.ipw.indent();
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express domain of values -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express unit of values -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express CRS -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express rotation -->");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        } else if (type instanceof PolylineType) {
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\"" + minOccurs + " type=\"gml:CurvePropertyType\"" + ">");
            this.ipw.indent();
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express domain/unit/crs of control points -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express allowed line forms -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express line attributes -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express overlaps -->");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        } else if (type instanceof SurfaceOrAreaType) {
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\"" + minOccurs + " type=\"gml:SurfacePropertyType\"" + ">");
            this.ipw.indent();
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express domain/unit/crs of control points -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express allowed line forms -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express line attributes -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express overlaps -->");
            if (type instanceof AreaType) {
                this.ipw.println("<!-- " + PRBLMTAG + " unable to express AREA constraint -->");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        } else if (type instanceof CompositionType) {
            CompositionType composition = (CompositionType)type;
            Table part = composition.getComponentType();
            Cardinality card = composition.getCardinality();
            minOccurs = "";
            if (card.getMinimum() > 1L) {
                minOccurs = " minOccurs=\"" + Long.toString(card.getMinimum()) + "\"";
            }
            String maxOccurs = "";
            if (card.getMaximum() != 1L) {
                maxOccurs = card.getMaximum() == Long.MAX_VALUE ? " maxOccurs=\"unbounded\"" : " maxOccurs=\"" + Long.toString(card.getMaximum()) + "\"";
            }
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\"" + minOccurs + maxOccurs + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element ref=\"" + Gml32Generator.getTransferName(part) + "\" type=\"" + Gml32Generator.getTransferName(part) + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        } else if (type instanceof ReferenceType) {
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\" type=\"gml:ReferenceType\"" + minOccurs + ">");
            this.ipw.indent();
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express target type -->");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        } else {
            this.ipw.println("<xsd:element name=\"" + Gml32Generator.getTransferName(attribute) + "\"" + minOccurs + ">");
            this.ipw.indent();
            this.declareType(type, null);
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        }
    }

    private void declareType(Type type, Domain domain) {
        String typeName = "";
        if (domain != null) {
            typeName = " name=\"" + Gml32Generator.getTransferName(domain) + "\"";
        }
        if (type instanceof PolylineType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.declarePolylineValue(domain, (PolylineType)type);
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof SurfaceOrAreaType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.declarePolylineValue(domain, (SurfaceOrAreaType)type);
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof CoordType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexContent>");
            this.ipw.indent();
            String base = domain != null && domain.getExtending() != null ? Gml32Generator.getTransferName(domain.getExtending()) : "gml:PointPropertyType";
            this.ipw.println("<xsd:restriction base=\"" + base + "\">");
            this.ipw.indent();
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express domain of values -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express unit of values -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express CRS -->");
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express rotation -->");
            this.ipw.unindent();
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexContent>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof BasketType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"BASKETVALUE\" type=\"BasketValue\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof EnumerationType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:restriction base=\"xsd:normalizedString\">");
            if (domain != null && domain.isFinal()) {
                this.ipw.indent();
                ArrayList ev = new ArrayList();
                this.buildEnumList(ev, "", ((EnumerationType)type).getConsolidatedEnumeration());
                Iterator iter = ((AbstractList)ev).iterator();
                while (iter.hasNext()) {
                    String value = (String)iter.next();
                    this.ipw.println("<xsd:enumeration value=\"" + value + "\"/>");
                }
                this.ipw.unindent();
            } else {
                this.ipw.println("<!-- " + PRBLMTAG + " unable to express elements of an extendable enumeration -->");
            }
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof NumericType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:restriction base=\"xsd:double\">");
            if (!type.isAbstract()) {
                this.ipw.indent();
                this.ipw.println("<xsd:minInclusive value=\"" + ((NumericType)type).getMinimum().doubleValue() + "\"/>");
                this.ipw.println("<xsd:maxInclusive value=\"" + ((NumericType)type).getMaximum().doubleValue() + "\"/>");
                this.ipw.unindent();
            }
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof TextType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:restriction base=\"xsd:normalizedString\">");
            if (((TextType)type).getMaxLength() > 0) {
                this.ipw.indent();
                this.ipw.println("<xsd:maxLength value=\"" + ((TextType)type).getMaxLength() + "\"/>");
                this.ipw.unindent();
            }
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else {
            throw new IllegalArgumentException("type " + type.getClass() + " not yet supported");
        }
    }

    private void declarePolylineValue(Domain domain, LineType type) {
        Table part;
        this.ipw.println("<xsd:complexContent>");
        this.ipw.indent();
        String base = domain != null && domain.getExtending() != null ? Gml32Generator.getTransferName(domain.getExtending()) : (type instanceof SurfaceOrAreaType ? "gml:SurfacePropertyType" : "gml:CurvePropertyType");
        this.ipw.println("<xsd:restriction base=\"" + base + "\">");
        this.ipw.indent();
        this.ipw.println("<!-- " + PRBLMTAG + " unable to express domain/unit/crs of control points -->");
        this.ipw.println("<!-- " + PRBLMTAG + " unable to express allowed line forms -->");
        this.ipw.println("<!-- " + PRBLMTAG + " unable to express line attributes -->");
        this.ipw.println("<!-- " + PRBLMTAG + " unable to express overlaps -->");
        if (type instanceof AreaType) {
            this.ipw.println("<!-- " + PRBLMTAG + " unable to express AREA constraint -->");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:restriction>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexContent>");
        if (type instanceof SurfaceOrAreaType && (part = ((SurfaceOrAreaType)type).getLineAttributeStructure()) != null) {
            this.addCurveSegmentWithLineAttr(type);
        }
    }

    private void declareLineForm(LineForm form) {
    }

    private void addCurveSegmentWithLineAttr(LineType domain) {
    }

    private void declareCurveSegmentWithLineAttr() {
    }

    private void buildEnumList(List accu, String prefix1, Enumeration enumer) {
        Iterator iter = enumer.getElements();
        String prefix = "";
        if (prefix1.length() > 0) {
            prefix = String.valueOf(prefix1) + ".";
        }
        while (iter.hasNext()) {
            Enumeration.Element ee = (Enumeration.Element)iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            if (subEnum != null) {
                this.buildEnumList(accu, String.valueOf(prefix) + ee.getName(), subEnum);
                continue;
            }
            accu.add(String.valueOf(prefix) + ee.getName());
        }
    }
}

