/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.MetaObject;
import ch.interlis.ili2c.metamodel.MetaobjectType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.Unit;
import java.util.List;

public abstract class Constant
extends Evaluable {
    Constant() {
    }

    public static class Undefined
    extends Constant {
        public String toString() {
            return "UNDEFINED";
        }

        void checkAssignment(Element target, Type targetType) {
            boolean anyMandatory = false;
            super.checkAssignment(target, targetType);
            if (targetType == null) {
                return;
            }
            Type curType = targetType;
            while (curType != null && !anyMandatory) {
                anyMandatory |= curType.isMandatory();
                if (!(curType instanceof TypeAlias)) break;
                Domain aliasing = ((TypeAlias)curType).getAliasing();
                Type type = curType = aliasing == null ? null : aliasing.getType();
            }
            if (anyMandatory) {
                throw new IllegalArgumentException(Element.formatMessage("err_constUndefined_assignToMandatory", target.toString()));
            }
        }
    }

    public static class Text
    extends Constant {
        String value;

        public Text(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }

        void checkAssignment(Element target, Type targetType) {
            super.checkAssignment(target, targetType);
            targetType = Type.findReal(targetType);
            if (targetType != null) {
                if (targetType instanceof TextType) {
                    int maxLen = ((TextType)targetType).getMaxLength();
                    if (this.value.length() > maxLen && maxLen > 0) {
                        throw new IllegalArgumentException(Element.formatMessage("err_constText_assignTooLong", target.toString(), this.toString(), Integer.toString(maxLen)));
                    }
                } else {
                    throw new IllegalArgumentException(Element.formatMessage("err_constText_assignOther", target.toString(), this.toString()));
                }
            }
        }
    }

    public static class Numeric
    extends Constant {
        double value;
        Unit unit;

        public Numeric(double value) {
            this.value = value;
            this.unit = null;
        }

        public Numeric(double value, Unit unit) {
            this.value = value;
            this.unit = unit;
        }

        public double getValue() {
            return this.value;
        }

        public Unit getUnit() {
            return this.unit;
        }

        void checkAssignment(Element target, Type targetType) {
            super.checkAssignment(target, targetType);
            targetType = Type.findReal(targetType);
            if (targetType != null && !(targetType instanceof NumericType)) {
                throw new IllegalArgumentException(Element.formatMessage("err_numericConst_assignOther", target.toString(), Double.toString(this.value)));
            }
        }
    }

    public static abstract class EnumConstOrRange
    extends Constant {
    }

    public static class Enumeration
    extends EnumConstOrRange {
        public static final String OTHERS = new String("OTHERS");
        String[] value;

        public Enumeration(List value) {
            this.value = value.toArray(new String[0]);
        }

        public String[] getValue() {
            return this.value;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(100);
            buf.append('#');
            int i = 0;
            while (i < this.value.length) {
                if (i > 0) {
                    buf.append('.');
                }
                buf.append(this.value[i]);
                ++i;
            }
            return buf.toString();
        }

        void checkAssignment(Element target, Type targetType) {
            super.checkAssignment(target, targetType);
            targetType = Type.findReal(targetType);
            if (targetType != null && !(targetType instanceof EnumerationType)) {
                throw new IllegalArgumentException(Element.formatMessage("err_enumConst_assignOther", target.toString(), this.toString()));
            }
        }
    }

    public static class EnumerationRange
    extends EnumConstOrRange {
        String[] commonPrefix;
        String from;
        String to;

        public EnumerationRange(String[] commonPrefix, String from, String to) {
            this.commonPrefix = commonPrefix;
            this.from = from;
            this.to = to;
        }

        public String[] getCommonPrefix() {
            return this.commonPrefix;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }
    }

    public static class Structured
    extends Constant {
        String value;
        Unit unit;

        public Structured(String value) {
            this.value = value;
        }

        public Structured(String value, Unit un) {
            this.value = value;
            this.unit = un;
        }

        public String toString() {
            return this.value;
        }

        public Unit getUnit() {
            return this.unit;
        }
    }

    public static class ReferenceToMetaObject
    extends Constant {
        MetaObject referred;

        public ReferenceToMetaObject(MetaObject referred) {
            this.referred = referred;
        }

        public String toString() {
            return "<Constant.ReferenceToMetaObject " + this.referred + ">";
        }

        public MetaObject getReferred() {
            return this.referred;
        }

        void checkAssignment(Element target, Type targetType) {
            super.checkAssignment(target, targetType);
            targetType = Type.findReal(targetType);
            if (target == null || targetType == null || this.referred == null) {
                return;
            }
            if (!(targetType instanceof MetaobjectType)) {
                throw new IllegalArgumentException(Element.formatMessage("err_constRefMeta_assignOther", target.toString(), this.referred.toString()));
            }
            if (this.referred == null) {
                return;
            }
            Table targetClass = ((MetaobjectType)targetType).getReferred();
            Table sourceClass = this.referred.getTable();
            if (targetClass == null || sourceClass == null) {
                return;
            }
            if (!sourceClass.isExtending(targetClass)) {
                throw new IllegalArgumentException(Element.formatMessage("err_constRefMeta_sourceNotExtTarget", target.toString(), this.referred.toString(), targetClass.toString(), sourceClass.toString()));
            }
        }
    }
}

