#include <gtk/gtk.h>
#include "gdancer.h"

typedef struct {
	GtkWidget *window;
	GtkWidget *button;
	GtkWidget *label;
	GtkWidget *vbox;
	gchar title[20];
	gchar info[200];
} gd_about;

void close_about (GtkWidget *widget, gd_about *about)
{
	gtk_widget_destroy (about->button);
	gtk_widget_destroy (about->label);
	gtk_widget_destroy (about->vbox);
	gtk_widget_destroy (about->window);
	about->button = NULL;
	about->label = NULL;
	about->vbox = NULL;
	about->window = NULL;
	g_free (about);
}

void show_about (void)
{
	gd_about *about = NULL;
	
	about = g_malloc0 (sizeof(gd_about));
	
	// Set variable for title
	g_snprintf (about->title, 19, "About %s", PROGNAME);
	// Set variable for info
	g_snprintf (about->info, 199, "%s is a XMMS Plugin\nThis is version %s written by\nTravis Emslander, FiGZ Productions\nVisit our page at http://figz.com/\n",PROGNAME, VERSION);
	// Make the about window
	about->window = gtk_window_new(GTK_WINDOW_DIALOG);
	// Set the title of the window
	gtk_window_set_title (GTK_WINDOW(about->window),
			(const gchar *) about->title);
	// Make Vertical box for packing widgets in
	about->vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add (GTK_CONTAINER(about->window), about->vbox);
	// Make label that says info
	about->label = gtk_label_new((const gchar *) about->info);
	// Make ok button
	about->button = gtk_button_new_with_label ("Close");
	gtk_signal_connect (GTK_OBJECT(about->button),
			"clicked",
			GTK_SIGNAL_FUNC(close_about),
			about);
	// pack those widgets
	gtk_box_pack_start (GTK_BOX(about->vbox), about->label,
			FALSE, FALSE, 5);
	gtk_box_pack_start (GTK_BOX(about->vbox), about->button,
			FALSE, FALSE, 5);
	// show widgets
	gtk_widget_show (about->vbox);
	gtk_widget_show (about->button);
	gtk_widget_show (about->label);
	gtk_widget_show (about->window);
}


