#include <glib.h>

#include "gdancer.h"
#include "audioprocessing.h"
#include "image.h"


// If you are planning on messing with the sensitivity settings and stuff
// you should set the folloowing
#define TESTING_MODE 0
// to 1 then run xmms from an xterm or something

static gint16 noise[15];

void process_audio(void) {
	/* These probably need to be adjustable */
	static gfloat vol_sense=35;
	static gfloat vol_sense_min=10;
	static gfloat vol_sense_dec=0.92;
	static gfloat vol_sense_inc=1.08;
	
	static gint busy = 0;

	gint i, n, t, diff;
	gfloat freq;
	gint vol;
	gint newtype = 2; // set newtype to neutral frame

	if (busy)
		return;

	/* This is a seperate thread so xmms doesn't have to wait for our
	 * slow asses */
//	GDK_THREADS_ENTER(); {
		busy = 1;
		vol = 0;
		n = 0;
		freq = 0;
		t = 0;

		/* Calculate average volume and frequency */
		for (i=0; i<15; i++) {
			freq+=i*noise[i];
			t+=noise[i];
			vol+=noise[i];
		}

		if (t)
			freq/=t;
		else
			freq=5;

		diff=(vol>=vol_sense);

		/* If volume is over the sensitivity, increase sensitivity,
		 * otherwise reduce sensitivity.
		 */
#if (TESTING_MODE)
		printf ("vol_sense: %f vol: %d freq: %f ", vol_sense, vol, freq);
#endif
		if (diff)
		{
			vol_sense*=vol_sense_inc;
			if (freq<3) {
#if (TESTING_MODE)
				printf ("BASS ");
#endif
				newtype=BASS; // BASS
			} else if (freq>5) {
#if (TESTING_MODE)
				printf ("TREBLE ");
#endif
				newtype=TREBLE; // TREBLE
			} else {
#if (TESTING_MODE)
				printf ("MIDRANGE ");
#endif
				newtype=MIDRANGE; // MIDRANGE
			}
		}
		else
		{
			if (vol_sense>vol_sense_min)
				vol_sense*=vol_sense_dec;
#if (TESTING_MODE)
			printf ("NEUTRAL ");
#endif
			newtype=NEUTRAL; // set newtype to neutral frame
		}
#if (TESTING_MODE)
		printf ("\n");
#endif

		// Do the change image routine for each dancer
		g_list_foreach (gdancers, (GFunc)gd_image_change_each, (gpointer) newtype);
		busy = 0;
//	} GDK_THREADS_LEAVE();
}

		

void gd_renderfreq (gint16 freq_data[2][256])
{
	/* Use freq data from xmms */
	gint t;
	if (gdancers == NULL)
		return; // don't have any gdancers going

	for (t = 0; t < 15; t++) {
		noise[t] = freq_data[0][t]>>7;
	}
	process_audio();
}


