from libdesklets.controls import Control

from IPopmail import IPopmail

import os, poplib, re, socket

class Popmail(Control, IPopmail):

	def __init__(self):
		self.__newmailcount = -1
		self.__popserver = None
		self.__port = 110
		self.__username = "username"
		self.__passwd = "pass"
		self.__mailapp = "thunderbird"
		self.__updateinterval = 300000
				
		self.__timerID = self._add_timer(self.__updateinterval, self.__checkmail)
		
		Control.__init__(self)
		
	def __set_popserver(self, server): self.__popserver = server
	
	def __set_port(self, port): self.__port = port
		
	def __set_username(self, username): self.__username = username
		
	def __set_password(self, password): self.__passwd = password
		
	def __set_mailapp(self, app): self.__mailapp = app
		
	def __set_update(self, update): 
		self.__updateinterval = update * 60000
		self._remove_timer(self.__timerID)
		self.__timerID = self._add_timer(self.__updateinterval, self.__checkmail)
		
	def __get_subjects(self):
		subjects = []
		rx_headers = re.compile(r"^(Subject)")
		
		try:
			socket.setdefaulttimeout(5)
			pop = poplib.POP3(self.__popserver, self.__port)
			pop.user(self.__username)
			pop.pass_(self.__passwd)
			
			status = pop.stat()
			for message in range(1,status[0]+1):
				# Retrieve headers
				response, lines, bytes = pop.top(message, 0) #0 lines of the body, don't need them...
				
				subject = "".join(filter(rx_headers.match, lines))
				subject = subject.replace("Subject: ", "")
				subjects.append(subject)
				
			pop.quit()
		except poplib.error_proto, msg:
			print 'in get_subjects: connection error: %s' %(msg,)
			self.pop = None
			subjects.append("login failed")
			subjects.append("change username/password")
		except socket.error, msg:
			print 'in get_subjects: socket error: %s' %(msg,)
			subjects.append("Socket error")
			subjects.append("Check pop server")
		
		return subjects

	def __get_newmailcount(self):
		return self.__newmailcount
		
	def __launch(self):
		""" launch mail application """
		
		self.__newmailcount = 0
		self._update("newmailcount") #force update to reset mail count
		os.system(self.__mailapp + " &")
		
	def __checkmail(self):
		""" should not be used often, normally gets called by the timer
			only use it when you want to force a new check (eg. at startup)
		"""
		
		try:
			socket.setdefaulttimeout(5)
			pop = poplib.POP3(self.__popserver, self.__port)
			pop.user(self.__username)
			pop.pass_(self.__passwd)
			
			status = pop.stat()
			newmails = status[0]
			
			pop.quit()

			self.__newmailcount = newmails
			self._update("newmailcount")
			
		except poplib.error_proto, msg:
			print 'in checkmail: connection error: %s' %(msg,)
			self.__newmailcount = -1
			self._update("newmailcount")
			
		except socket.error, msg:
			print 'in checkmail: socket error: %s' %(msg,)
			self.__newmailcount = -1
			self._update("newmailcount")

		return True
		
	popserver = property(fset=__set_popserver, doc = "set popserver")
	port = property(fset=__set_port, doc = "set port")
	username = property(fset=__set_username, doc = "set username")
	password = property(fset=__set_password, doc = "set password")
	newmailcount = property(fget=__get_newmailcount, doc = "get unread mail count")
	launch = property(fget=__launch, doc = "Launch the mail application")
	mailapp = property(fset= __set_mailapp, doc = "Set the prefered mail application")
	subjects = property(fget=__get_subjects, doc = "Get the subjects of new messages")
	updateinterval = property(fset=__set_update, doc="Set the update period (in seconds)")
	checkmail = property(fget=__checkmail, doc="Check for new mail")
	
def get_class(): return Popmail
