/* This file is a test for the XSLT engine working on Gdome documents.
 *
 * Copyright (C) 2002 Claudio Sacerdoti Coen <sacerdot@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please send an email to <sacerdot@cs.unibo.it>
 */

#include <string>
#include <iostream>
#include "GdomeSmartDOMXSLT.hh"

namespace DOM = GdomeSmartDOM;
namespace DOMX = GdomeSmartDOMExt;

#define	OUTPUT_FILE		"../../test_files/output.xml"
#define CORRECT_OUTPUT_FILE	"../../test_files/output.xml.correct"

int
main(void)
{
   int bytes;
   DOM::DOMImplementation di;
   std::vector< std::pair<DOM::GdomeString, DOM::GdomeString> > params;

   params.push_back(std::make_pair(DOM::GdomeString("parameter1"), DOM::GdomeString("'value1'")));
   params.push_back(std::make_pair(DOM::GdomeString("parameter2"), DOM::GdomeString("'value2'")));
   params.push_back(std::make_pair(DOM::GdomeString("parameter3"), DOM::GdomeString("'value3'")));

   DOM::Document input = di.createDocumentFromURI("../../test_files/input.xml");
   DOM::Document style = di.createDocumentFromURI("../../test_files/stylesheet.xsl");

   DOMX::XSLTStylesheet style_libxslt(style);
   DOM::Document output = style_libxslt.apply(input, params);
   style_libxslt.save(output, OUTPUT_FILE);

   std::cout << "The test was successful iff " << OUTPUT_FILE << " is equal to " << CORRECT_OUTPUT_FILE << std::endl;

   return 0;
}
