static char rcsid[] = "$Id: code_lib.c,v 1.7 2001/04/25 17:17:04 mhucka Exp $";

/*
** $Log: code_lib.c,v $
** Revision 1.7  2001/04/25 17:17:04  mhucka
** Misc. small changes to improve portability and address compiler warnings.
**
** Revision 1.6  2000/10/09 23:02:14  mhucka
** Portability fixes.
**
** Revision 1.5  2000/09/21 19:44:31  mhucka
** Added parens around assignments inside if/then conditionals to please gcc.
**
** Revision 1.4  2000/06/12 04:55:20  mhucka
** Fixed trivial errors in some printf format strings.
**
** Revision 1.3  1994/03/19 23:28:07  dhb
** Added LIBRARY initialization code to run startup function generated
** from the library startup script.
**
** Revision 1.2  1993/10/16  00:29:38  dhb
** Last line of code_lib's output was not newline terminated!
**
** Revision 1.1  1992/12/11  19:05:27  dhb
** Initial revision
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

main(argc,argv)
     int argc;
     char **argv;
{
  FILE	*outfile;
  FILE	*fp;
  int	nxtarg;
  char	*libname;
  char	name[100];
  char	date[100];
  time_t clock;
  int	i;

  if(argc < 2){
    printf("usage: %s libraryname [-o file]\n", argv[0]);
    return;
  }
  libname = argv[1];
  nxtarg = 1;
  outfile = stdout;
  while(++nxtarg < argc){
    if(strcmp(argv[nxtarg],"-o") == 0){
      if((outfile = fopen(argv[++nxtarg],"w")) == NULL){
	printf("unable to open file '%s' for writing\n",argv[nxtarg]);
	return;
      }
    }
  }
  fprintf(outfile,"LIBRARY_%s()\n{\n",libname);
  /*
   ** get the current date
   */
  time(&clock);
  strcpy(date,ctime(&clock));
  /*
   ** remove an carriage returns
   */
  for(i=0;i<strlen(date);i++){
    if(date[i] == '\n'){
      date[i] = ' ';
    }
  }
  /*
   ** make the header
   */
  fprintf(outfile,"LibraryHeader(\"%s\",",libname);
  fprintf(outfile,"\"%s\");",date);
  
  /*
   ** is there a data section?
   */
  sprintf(name,"%s_d@.c",libname);
  if((fp = fopen(name,"r"))){
    fprintf(outfile,"DATA_%s();\n",libname);
  }
  
  /*
   ** is there a function section?
   */
  sprintf(name,"%s_f@.c",libname);
  if((fp = fopen(name,"r"))){
    fprintf(outfile,"FUNC_%s();\n",libname);
  }
  
  /*
   ** is there a startup section?
   */
  sprintf(name,"%s_g@.c",libname);
  if((fp = fopen(name,"r"))){
    fprintf(outfile,"STARTUP_%s();\n",libname);
  }
  fprintf(outfile,"}\n");
  exit(0);
}
