/****************************************************************************
** sysinfo.cc
**
** Michael S. Borella <mike@borella.net>
**
** Methods for the system information class
**
****************************************************************************/

#include <unistd.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/utsname.h>
#include "sysinfo.h"

//---------------------------------------------------------------------------
//
// Sysinfo::Sysinfo()
//
// Constructor method.  Does most of the work
//
//---------------------------------------------------------------------------

Sysinfo::Sysinfo() throw (EH_system)
{
  struct utsname machine;

  // Get the machine-specific info
  if (uname(&machine) == -1)
    {
      EH_system e("can't get system info");
      throw e;
    }

  // store all of the items locally
  _name = machine.sysname;
  _release = machine.release;
  _build = machine.version;
  _hardware = machine.machine;
  _domainname = machine.nodename;

}











