/*
    main.h - Provide the main window and related routines
    Copyright (c) 1999,2006  Joey Schulze <joey@infodrom.org>

    This file is part of the Gerstensaft package.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.
*/

#ifndef __MAIN_H__
#define __MAIN_H__

#include <gtk/gtk.h>

#define MOD_SEND	0
#define MOD_RECEIVE	1
#define MOD_MESSAGE	2

struct s_main_data {
  char *dir;	/* Current directory */
  unsigned short int mode;
  GtkWidget *modeitem[3];
  /* Mode: Send */
  GtkWidget *listbox;
  GtkWidget *dirinput;
  GtkWidget *filebox;
  GtkWidget *sendbutton;
  GtkWidget *clearbutton;
  GtkWidget *addbutton;
  GtkWidget *selectbutton;
  GtkWidget *unselectbutton;
  /* Mode: Receive */
  GtkWidget *receiver;
  GtkWidget *rdirinput;
  GtkWidget *rinfo;
  GtkWidget *rcomment;
  /* Mode: Message */
  GtkWidget *addrinput;
  GtkWidget *msgsend;
  GtkWidget *msginput;
  unsigned short int addrok;
  /* Mode Containers */
  GtkWidget *container_send;
  GtkWidget *container_receive;
  GtkWidget *container_message;
};

void main_window(unsigned short int startmode);

extern GdkPixmap *dir_pixmap, *doc_pixmap;
extern GdkBitmap *dir_mask, *doc_mask;

void main_clear (gpointer data);

#endif /* __MAIN_H__ */
