#include "buttons.hh"
#include <gfc/gtk/box.hh>
#include <gfc/gtk/image.hh>
#include <gfc/gtk/label.hh>
#include <iostream>

// ImageButton

ImageButton::ImageButton(const String& xpm_filename, const String& label_text)
{
	// Create box for image and label
	Gtk::HBox *box = new Gtk::HBox;
	box->set_border_width(2);

	// Now on to the image stuff
	Gtk::Image *image = new Gtk::Image(xpm_filename);

	// Create a label for the button
	Gtk::Label *label = new Gtk::Label(label_text);

	// Pack the image and label into the box
	box->pack_start(*image, false, false, 3);
	box->pack_start(*label, false, false, 3);

	box->show_all();
	add(*box);
}

ImageButton::~ImageButton()
{
}

void
ImageButton::on_clicked()
{
	std::cout << "Hello again - cool button was pressed" << std::endl;
}

// ButtonWindow

ButtonWindow::ButtonWindow()
{
	set_title("Pixmap'd Buttons!");
	set_border_width(10);

	// Create a new button
	ImageButton *button = new ImageButton("info.xpm", "cool button");
	add(*button);
	button->show();
}

ButtonWindow::~ButtonWindow()
{
}

int main(int argc, char *argv[])
{
	using namespace Main;

	init(&argc, &argv);

	ButtonWindow window;
	window.sig_destroy().connect(sigc::ptr_fun(&GFC::Main::quit));
	window.show();

	run();
	return 0;
}

