/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/// @file gfc/gtk/checkmenuitemsignals.hh
/// @brief Gtk::CheckMenuItem virtual signal handlers.
///
/// Provides Gtk::CheckMenuItemSignals, an abstract base class that implements
/// the overridable virtual signal handlers for Gtk::CheckMenuItem objects.

#ifndef GFC_GTK_MENU_CHECK_ITEM_SIGNALS_HH
#define GFC_GTK_MENU_CHECK_ITEM_SIGNALS_HH

#ifndef GFC_GTK_MENU_ITEM_SIGNALS_HH
#include <gfc/gtk/menuitemsignals.hh>
#endif

namespace GFC {

namespace Gtk {

/// @class CheckMenuItemSignals checkmenuitemsignals.hh gfc/gtk/checkmenuitemsignals.hh
/// @brief Abstract base class that implements the virtual signal handlers for Gtk::CheckMenuItem.

class CheckMenuItemSignals : public MenuItemSignals
{
protected:
/// @name Constructors
/// @{

	CheckMenuItemSignals(CheckMenuItem *check_menu_item);
	///< Construct a new CheckMenuItemSignals object.
	///< @param check_menu_item A CheckMenuItem object inheriting the CheckMenuItemSignals implementation.

	virtual ~CheckMenuItemSignals() = 0;
	///< Destructor.

/// @}

public:
/// @name Signal Handlers
/// @{
	virtual void on_toggled();
	///< Called when the state of the check box is changed. Call get_active() to discover the new state.

/// @}
};

} // namespace Gtk

} // namespace GFC

#endif // GFC_GTK_MENU_CHECK_ITEM_SIGNALS_HH

