/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  fontbuttonsignals.cc - Gtk::FontButton virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "fontbutton.hh"
#include "fontbuttonsignals.hh"
#include "private/fontbuttonclass.hh"

using namespace GFC;

/*  Gtk::FontButtonSignals
 */

Gtk::FontButtonSignals::FontButtonSignals(FontButton *font_button)
: ButtonSignals(font_button)
{
	Gtk::FontButtonClass::init(GTK_FONT_BUTTON_GET_CLASS(font_button->gtk_font_button()));
}

Gtk::FontButtonSignals::~FontButtonSignals()
{
}

void
Gtk::FontButtonSignals::on_font_set()
{
	GtkFontButtonClass *g_class = FontButtonClass::get_parent_class(instance_);
	if (g_class->font_set)
		g_class->font_set((GtkFontButton*)instance_);
}

/*  Gtk::FontButtonClass
 */

void
Gtk::FontButtonClass::init(GtkFontButtonClass *g_class)
{
	g_class->font_set = &font_set_proxy;
}

GtkFontButtonClass*
Gtk::FontButtonClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_FONT_BUTTON_GET_CLASS(instance));
	return static_cast<GtkFontButtonClass*>(ptr);
}

GType
Gtk::FontButtonClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_FONT_BUTTON);
	}
	return type;
}

void*
Gtk::FontButtonClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::FontButtonClass::font_set_proxy(GtkFontButton *font_button)
{
	void *ptr = g_object_get_qdata((GObject*)font_button, G::ObjectSignals::quark());
	if (ptr)
		static_cast<FontButtonSignals*>(ptr)->on_font_set();
	else
	{
		GtkFontButtonClass *g_class = FontButtonClass::get_parent_class(font_button);
		if (g_class->font_set)
			g_class->font_set(font_button);
	}
}

