/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  handlebox.cc - GtkHandleBox C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "handlebox.hh"
#include "private/handleboxclass.hh"
#include "private/marshal.hh"
#include "../gdk/window.hh"

using namespace GFC;

/*  Gtk::HandleBox
 */

Gtk::HandleBox::HandleBox(GtkHandleBox *handle_box, bool owns_reference)
: Bin((GtkBin*)handle_box, owns_reference)
{
}

Gtk::HandleBox::HandleBox(ShadowType shadow_type)
: Bin((GtkBin*)HandleBoxClass::create())
{
	set_shadow_type(shadow_type);
}

Gtk::HandleBox::~HandleBox()
{
}

Gdk::Window*
Gtk::HandleBox::get_bin_window() const
{
	return G::Object::wrap<Gdk::Window>(gtk_handle_box()->bin_window);
}

Gdk::Window*
Gtk::HandleBox::get_float_window() const
{
	return G::Object::wrap<Gdk::Window>(gtk_handle_box()->float_window);
}

/*  Gtk::HandleBox Signals
 */

const Gtk::HandleBox::ChildAttachedSignalType Gtk::HandleBox::child_attached_signal("child_attached", (GCallback)&Marshal::void_widget_callback2);

const Gtk::HandleBox::ChildDetachedSignalType Gtk::HandleBox::child_detached_signal("child_detached", (GCallback)&Marshal::void_widget_callback2);

