/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  accellabel.inl - Gtk::AccelLabel inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkAccelLabel*
GFC::Gtk::AccelLabel::gtk_accel_label() const
{
	return reinterpret_cast<GtkAccelLabel*>(instance_);
}

inline
GFC::Gtk::AccelLabel::operator GtkAccelLabel* () const
{
	return this ? gtk_accel_label() : 0;
}

inline unsigned int
GFC::Gtk::AccelLabel::get_accel_width() const
{
	return gtk_accel_label_get_accel_width(gtk_accel_label());
}

inline void
GFC::Gtk::AccelLabel::set_accel_closure(GClosure *accel_closure)
{
	gtk_accel_label_set_accel_closure(gtk_accel_label(), accel_closure);
}

inline bool
GFC::Gtk::AccelLabel::refetch()
{
	return gtk_accel_label_refetch(gtk_accel_label());
}

