// CONSTRAINT_DIALOG.CPP

// Copyright (C) 2006 Donald Curtis, Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "constraint_dialog.h"

#include <gtk/gtk.h>

#include <ghemical/eng1_mm.h>

#include <string>
#include <sstream>
#include <iostream>
using namespace std;

constraint_dialog::constraint_dialog(gtk_project * p1) : glade_dialog("glade/constraint_dialog.glade")
{
	prj = p1;
	
	dialog = NULL;
	atoms[0] = atoms[1] = NULL;
	
	checkbutton_mindist = entry_mindist = entry_minFC = NULL;
	checkbutton_maxdist = entry_maxdist = entry_maxFC = NULL;
	checkbutton_skip_nb = NULL;
	
	dialog = glade_xml_get_widget(xml, "constraint_dialog");
	if (dialog == NULL) { cout << "constraint_dialog : glade_xml_get_widget() failed!!!" << endl; return; }
	
	// collect our selected atoms ; if any problems then
	// just close the dialog and show an error message...
	
	setup * owner = prj->GetCurrentSetup();
	if (owner != NULL)
	{
		int count = 0;
		for (iter_al it1 = prj->GetAtomsBegin();it1 != prj->GetAtomsEnd();it1++)
		{
			if ((*it1).GetSelected())
			{
				atoms[count] = & (* it1);
				count++;
			}
			
			if (count >= 2) break;
		}
		
		if( count != 2 )
		{
			gtk_widget_destroy(dialog);
			
			prj->Message("Please select exactly two atoms\nfor adding a constraint.");
			return;
		}
	}
	
	// initialize the widgets...
	
	checkbutton_mindist = glade_xml_get_widget(xml, "checkbutton_mindist");
	entry_mindist = glade_xml_get_widget(xml, "entry_mindist");
	entry_minFC = glade_xml_get_widget(xml, "entry_minFC");
	
	checkbutton_maxdist = glade_xml_get_widget(xml, "checkbutton_maxdist");
	entry_maxdist = glade_xml_get_widget(xml, "entry_maxdist");
	entry_maxFC = glade_xml_get_widget(xml, "entry_maxFC");
	
	checkbutton_skip_nb = glade_xml_get_widget(xml, "checkbutton_skip_nb");
	
	// ...and set the default values.
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_mindist), true);
	gtk_entry_set_text(GTK_ENTRY(entry_mindist), "0.10");
	gtk_entry_set_text(GTK_ENTRY(entry_minFC), "1.0e+5");
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_maxdist), true);
	gtk_entry_set_text(GTK_ENTRY(entry_maxdist), "0.10");
	gtk_entry_set_text(GTK_ENTRY(entry_maxFC), "1.0e+5");
	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_skip_nb), false);
	
	// connect the handlers...
	
	GtkWidget * option_menu;
	unsigned int i;
	
	glade_xml_signal_connect_data(xml, "on_constraint_ok_clicked", (GtkSignalFunc) handler_ButtonOk, (gpointer)this);
	glade_xml_signal_connect_data(xml, "on_constraint_cancel_clicked", (GtkSignalFunc) handler_ButtonCancel, (gpointer)this);
	
	gtk_dialog_run(GTK_DIALOG(dialog));	// MODAL
}

constraint_dialog::~constraint_dialog()
{
}

void constraint_dialog::handler_ButtonOk(GtkWidget *, gpointer data)
{
	constraint_dialog * ref = (constraint_dialog *) data;
	cout << "handler_ButtonOK() : ref = " << ref << endl;
	
	const gchar * buffer;
	
bool has_mindist = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ref->checkbutton_mindist));
float mindist; buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_mindist)); istringstream istr1a(buffer); istr1a >> mindist;
float minFC; buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_minFC)); istringstream istr1b(buffer); istr1b >> minFC;

bool has_maxdist = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ref->checkbutton_maxdist));
float maxdist; buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_maxdist)); istringstream istr2a(buffer); istr2a >> maxdist;
float maxFC; buffer = gtk_entry_get_text(GTK_ENTRY(ref->entry_maxFC)); istringstream istr2b(buffer); istr2b >> maxFC;

bool skip_nb = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ref->checkbutton_skip_nb));
	
	// do a quick sanity check...
	
	static const char err1[] = "Both the distance and the force\nconstant must be positive values.";
	static const char err2[] = "Must have either minimum or\nmaximum distance constraint, or both.";
	static const char err3[] = "Minimum distance must be smaller\nor equal to maximum distance.";
	
	if (has_mindist)
	{
		if (mindist < 0.0 || minFC < 0.0)
		{
			ref->prj->ErrorMessage(err1);
			return;
		}
	}
	
	if (has_maxdist)
	{
		if (maxdist < 0.0 || maxFC < 0.0)
		{
			ref->prj->ErrorMessage(err1);
			return;
		}
	}
	
	if (!has_mindist && !has_maxdist)
	{
		ref->prj->ErrorMessage(err2);
		return;
	}
	
	if ((has_mindist && has_maxdist) && (mindist > maxdist))
	{
		ref->prj->ErrorMessage(err3);
		return;
	}
	
	// ok, close the dialog and add the constraint.
	
	gtk_widget_destroy(ref->dialog);
	
	constraint_dst c(ref->atoms[0], ref->atoms[1]);
	
	constraint_dst::type tp = constraint_dst::Disabled;
	if (has_mindist && has_maxdist) tp = constraint_dst::MinAndMax;
	else if (has_mindist) tp = constraint_dst::MinOnly; else tp = constraint_dst::MaxOnly;
	
	c.SetType(tp);
	c.SetSkipMMnb(skip_nb);
	
	if (has_mindist)
	{
		c.SetMinDist(mindist);
		c.SetMinFC(minFC);
	}
	
	if (has_maxdist)
	{
		c.SetMaxDist(maxdist);
		c.SetMaxFC(maxFC);
	}
	
	ref->prj->AddConstraint(c);
	
	printf("Constraint List:\n");
	for (iter_CDl it1 = ref->prj->GetConstD_begin();it1 != ref->prj->GetConstD_end();it1++)
	{
		int i1 = (* it1).atmr[0]->index;
		int i2 = (* it1).atmr[1]->index;
		int tp = (int) (* it1).GetType();
		bool skipnb = (* it1).GetSkipMMnb();
		float mind = (* it1).GetMinDist();
		float minfc = (* it1).GetMinFC();
		float maxd = (* it1).GetMinDist();
		float maxfc = (* it1).GetMinFC();
		
		printf("%d - %d ; %d %d %f %f %f %f\n", i1, i2, tp, skipnb, mind, minfc, maxd, maxfc);
	}
}

void constraint_dialog::handler_ButtonCancel(GtkWidget *, gpointer data)
{
	constraint_dialog * ref = (constraint_dialog *) data;
	cout << "handler_ButtonCancel() : ref = " << ref << endl;
	
	// close the dialog...
	
	gtk_widget_destroy(ref->dialog);
}

/*################################################################################################*/

// eof
