// CONFIG_MM1_DIALOG.H : write a short description here...

// Copyright (C) 2002 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef GAMESS_DIALOG_H
#define GAMESS_DIALOG_H

#include "ghemicalconfig2.h"

#ifdef ENABLE_GAMESS

#include <gtk/gtk.h>
#include <glade/glade.h>
#include "glade_dialog.h"
#include "gtk_project.h"
#include "filetrans.h"

class gamess_dialog;

/*################################################################################################*/

class config_file_save_dialog : public file_dialog
{
	private:
	
	static const char title[];
	static gamess_dialog * docv;
	
	public:
	
	config_file_save_dialog(gamess_dialog *);
	~config_file_save_dialog(void);
	
	bool OkEvent(const char *);	// virtual
	void CancelEvent(void);		// virtual
};

/*################################################################################################*/

class config_file_submit_dialog : public file_dialog
{
	private:
	
	static const char title[];
	static gamess_dialog * docv;
	
	public:
	
	config_file_submit_dialog(gamess_dialog *);
	~config_file_submit_dialog(void);
	
	bool OkEvent(const char *);	// virtual
	void CancelEvent(void);		// virtual
};

/*################################################################################################*/

class gamess_dialog : public glade_dialog
{
	protected:
	
	GtkWidget * dialog;
	gtk_project * prj;
	
	private:
	fGL distance(const  fGL*, const fGL* );
	void PrintData(GtkTextBuffer *, GtkTextIter *);

	public:
	static ostringstream backupstr;
	static int charge;
	
	gamess_dialog(gtk_project *);
	~gamess_dialog(void);

	void delay_Destroy(void);
	void delay_Save(const char* filename);

	static void handler_Destroy(GtkWidget *, gpointer);
	
	static void UpdateData(GtkWidget *, gpointer);

	static void handler_ButtonReview(GtkWidget *, gpointer);
	static void handler_ButtonSave(GtkWidget *, gpointer);
	static void handler_ButtonCancel(GtkWidget *, gpointer);
	static void handler_ButtonSubmit(GtkWidget *, gpointer);

	static void handler_OptionMenuChanged(GtkMenuShell *menu_shell, gpointer data);
	static void handler_CheckButtonToggled(GtkWidget *widget, gpointer data);

	
	static void handler_ButtonReviewOK(GtkWidget *, gpointer);
	static void handler_ButtonReviewCancel(GtkWidget *, gpointer);
};

#endif  // ENABLE_GAMESS

/*################################################################################################*/

#endif	// GAMESS_DIALOG_H

// eof
