/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __IO_H__
#define __IO_H__

#include <glib.h>
#include <libgift/libgift.h>

guint gift_id_new (void);

void gift_send_local_str (gchar *str);
void gift_send_local (gchar *key, gchar *sub, ...);

void gift_send_str (const gchar *src);
void gift_send (gchar *key, gchar *sub, ...);
void gift_send_interface (Interface *out);

gboolean gift_receive (void);

gboolean gift_connect (const gchar *server, gint port);
void gift_disconnect (void);
void gift_quit (void);

gboolean gift_connected (void);

#endif
