/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "main.h"

#include <libgift/libgift.h>

#include "configure.h"
#include "io.h"
#include "event.h"

#include "ui.h"
#include "ui_connect.h"
#include "ui_menu.h"
#include "ui_util.h"

static void
giftui_menu_connect_clicked (void)
{
	giftui_connect_create (GTK_STOCK_NEW, _("Please choose the giFT server : "),
			       giftui_config_get_str (PREFS_DAEMON_HOST),
			       giftui_config_get_int (PREFS_DAEMON_PORT),
			       giftui_config_get_bool (PREFS_DAEMON_LAUNCH));
	
	return;
}

static void
giftui_menu_disconnect_clicked (void)
{
	if (gift_connected ())
		gift_disconnect ();
	
	return;
}

static void
giftui_menu_new_tab_clicked (GiftuiParent *parent, guint action, GtkWidget *widget)
{
	GtkWidget *current, *w;
	
	switch (action)
	{
	case GIFTUI_CHILD_SEARCH:
		w = giftui_search_new ();
		break;
		
	case GIFTUI_CHILD_BROWSE:
		w = giftui_browse_new (NULL);
		break;
		
	default:
		return;
	}
	
	current = giftui_parent_current_child (parent);
	
	giftui_parent_insert_child (parent, current, w);
	giftui_parent_raise_child (parent, w);
			  
	return;
}

static void
giftui_menu_close_tab_clicked (GiftuiParent *parent, guint action, GtkWidget *widget)
{
	GiftuiChild *w;
	
	w = GIFTUI_CHILD (giftui_parent_current_child (parent));
	
	if (w->type != GIFTUI_CHILD_ABOUT &&
	    w->type != GIFTUI_CHILD_TRANSFER &&
	    w->type != GIFTUI_CHILD_PREF)
	{
		giftui_parent_remove_child (parent, GTK_WIDGET (w));
		gtk_widget_destroy (GTK_WIDGET (w));
	}
	
	return;
}

static void
giftui_menu_next_tab_clicked (GiftuiParent *parent, guint action, GtkWidget *widget)
{
	GtkWidget *w;
	
	w = giftui_parent_current_child (parent);
	w = giftui_parent_next_child (parent, w);
	if (w)
		giftui_parent_raise_child (parent, w);
	
	return;
}

static void
giftui_menu_prev_tab_clicked (GiftuiParent *parent, guint action, GtkWidget *widget)
{
	GtkWidget *w;
	
	w = giftui_parent_current_child (parent);
	w = giftui_parent_prev_child (parent, w);
	if (w)
		giftui_parent_raise_child (parent, w);
	
	return;
}

static void
giftui_menu_backward_tab_clicked (GiftuiParent *parent, guint action, GtkWidget *widget)
{
	GtkWidget *w, *prev;
	
	w = giftui_parent_current_child (parent);
	if ((prev = giftui_parent_prev_child (parent, w)))
		prev = giftui_parent_prev_child (parent, prev);
	giftui_parent_move_child (parent, prev, w);
	
	return;
}

static void
giftui_menu_forward_tab_clicked (GiftuiParent *parent, guint action, GtkWidget *widget)
{
	GtkWidget *w, *next;
	
	w = giftui_parent_current_child (parent);
	if ((next = giftui_parent_next_child (parent, w)))
		giftui_parent_move_child (parent, next, w);
	
	return;
}

static GtkItemFactoryEntry menu_items[] =
{
	
	{ "/_File", "<ALT>F", NULL, 0, "<Branch>", NULL},
	
	{ "/_File/tear1", NULL, NULL, 0, "<Tearoff>", NULL},
	{ "/_File/_Connect", "<CTRL>C", giftui_menu_connect_clicked, 1, "<StockItem>", GTK_STOCK_EXECUTE},
	{ "/_File/_Disconnect", "<CTRL>D", giftui_menu_disconnect_clicked, 1, "<StockItem>", GTK_STOCK_CLOSE},
	{ "/_File/sep1", NULL, NULL, 0, "<Separator>", NULL},
	{ "/_File/_Quit", "<CTRL>Q", giftui_exit, 0, "<StockItem>", GTK_STOCK_QUIT},
	
	
	{ "/_Tabs", "<ALT>T", NULL, 0, "<Branch>", NULL},
	
	{ "/_Tabs/tear1", NULL, NULL, 0, "<Tearoff>", NULL},
	{ "/_Tabs/New", NULL, NULL, 0, "<Branch>", NULL},
	{ "/_Tabs/New/Browse", "", giftui_menu_new_tab_clicked, GIFTUI_CHILD_BROWSE, "<StockItem>", GTK_STOCK_INDEX},
	{ "/_Tabs/New/Search", "", giftui_menu_new_tab_clicked, GIFTUI_CHILD_SEARCH, "<StockItem>", GTK_STOCK_FIND},
	{ "/_Tabs/Close", "<CTRL>W", giftui_menu_close_tab_clicked, 0, "<StockItem>", GTK_STOCK_CLOSE},
	{ "/_Tabs/sep1", NULL, NULL, 0, "<Separator>", NULL},
	{ "/_Tabs/_Prev", "<CTRL>P", giftui_menu_prev_tab_clicked, 0, "<StockItem>", GTK_STOCK_GO_BACK},
	{ "/_Tabs/_Next", "<CTRL>N", giftui_menu_next_tab_clicked, 0, "<StockItem>", GTK_STOCK_GO_FORWARD},
	{ "/_Tabs/_BackWard", "<CTRL>B", giftui_menu_backward_tab_clicked, 0, "<StockItem>", GTK_STOCK_GOTO_FIRST},
	{ "/_Tabs/_Forward", "<CTRL>F", giftui_menu_forward_tab_clicked, 0, "<StockItem>", GTK_STOCK_GOTO_LAST}
	
	/*,
	  { "/_Help", NULL, NULL, 0, "<LastBranch>"},
	  { "/_Help/About", NULL, NULL, 0, "<Item>"}*/
};

GtkWidget *
giftui_menu_create (GtkWidget *window, GiftuiParent *parent)
{
	GtkWidget *menubar;
	
	menubar = gtk_menu_from_factoryentry (menu_items, GTK_TYPE_MENU_BAR,
					      sizeof (menu_items) / sizeof (menu_items[0]),
					      window, parent);
	gtk_widget_show_all (menubar);
	
	return menubar;
}
