/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __UI_PARENT_H__
#define __UI_PARENT_H__

#include <gtk/gtk.h>

/*
  GtkVBox
      +----GiftuiParent
*/

#define GIFTUI_TYPE_PARENT (giftui_parent_get_type ())
#define GIFTUI_PARENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIFTUI_TYPE_PARENT, GiftuiParent))
#define GIFTUI_PARENT_CLASS(class) (G_TYPE_CHECK_CLASS_CAST ((class), GIFTUI_TYPE_PARENT, GiftuiParentClass))
#define GIFTUI_IS_PARENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIFTUI_TYPE_PARENT))
#define GIFTUI_IS_PARENT_CLASS(class) (G_TYPE_CHECK_CLASS_TYPE ((class), GIFTUI_TYPE_PARENT))
#define GIFTUI_PARENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GIFTUI_TYPE_PARENT, GiftuiParentClass))

typedef struct _GiftuiParent GiftuiParent;
typedef struct _GiftuiParentClass GiftuiParentClass;

struct _GiftuiParent
{
	GtkVBox parent_instance;
	
	/* < not_that_private_data > */
	GList *children;
};

struct _GiftuiParentClass
{
	GtkVBoxClass parent_class;
	
	void (* insert) (GiftuiParent *parent,
			 GtkWidget *position,
			 GtkWidget *child);
	void (* remove) (GiftuiParent *parent,
			 GtkWidget *child);
	void (* move) (GiftuiParent *parent,
		       GtkWidget *position,
		       GtkWidget *child);
	void (* raise) (GiftuiParent *parent,
			GtkWidget *child);
	
	GtkWidget *(* current) (GiftuiParent *parent);
};

GType giftui_parent_get_type (void);

GtkWidget *giftui_parent_current_child (GiftuiParent *pa);
GtkWidget *giftui_parent_next_child (GiftuiParent *pa, GtkWidget *ch);
GtkWidget *giftui_parent_prev_child (GiftuiParent *pa, GtkWidget *ch);

void giftui_parent_insert_child (GiftuiParent *pa, GtkWidget *pos,
				 GtkWidget *ch);
void giftui_parent_remove_child (GiftuiParent *pa, GtkWidget *ch);

void giftui_parent_move_child (GiftuiParent *pa, GtkWidget *pos,
			       GtkWidget *ch);
void giftui_parent_raise_child (GiftuiParent *pa, GtkWidget *ch);
void giftui_parent_save_children_positions (GiftuiParent *pa);

#endif
