/*-
 * LongRun mode setting command for GKrellM LongRun Plugin
 *	Masaharu FUJITA <m@fjts.org>, 24 June 2001
 *
 * Copyright (c) 2001 Masaharu FUJITA
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/sysctl.h>

#define LONGRUN_MODE_MINFREQUENCY       0x00
#define LONGRUN_MODE_ECONOMY            0x01
#define LONGRUN_MODE_PERFORMANCE        0x02
#define LONGRUN_MODE_MAXFREQUENCY       0x03
#define LONGRUN_MODE_UNKNOWN            0x04
#define LONGRUN_MODE_MAX                0x04

void
usage(char *command)
{
	fprintf(stderr,"usage: %s mode\n",command);
	fprintf(stderr,
		"\tmode: longrun mode (0 to 3, 0 is max saving power).\n");
}

int
main (int argv, char *argc[])
{
	u_int newmode;
	u_int oldmode;
	size_t newsize;
	size_t oldsize;

	if ( argv != 2 ) {
		usage(argc[0]);
		return -1;
	}

	newmode = atoi(argc[1]);
	if ( newmode < LONGRUN_MODE_MINFREQUENCY
			|| newmode > LONGRUN_MODE_MAXFREQUENCY ) {
		usage(argc[0]);
		return -1;
	}

	newsize = sizeof(newmode);
	oldsize = sizeof(oldmode);

	if ( sysctlbyname("hw.crusoe.longrun", &oldmode, &oldsize,
			&newmode, newsize) < 0 ) {
		fprintf(stderr,"%s: Operation not permitted.\n",argc[0]);
		return -1;
	}

	return 0;
}
