// $Id: viewport.cc,v 1.20 2002/07/18 16:19:23 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "bin.hh"

// XXX : adjustments

class Gtk_Viewport : public Gtk_Bin
{public:
	typedef Gtk_Bin Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	Gtk_Viewport();
	virtual void GCInclude(const Widget &w, CxxFile &f) const;
};

static Gtk_Viewport Gtk_Viewport;

void Gtk_Viewport::ConstructionArgs(Widget const &w, CxxFile &f) const
{  if (GTKMM1) f.FunctionArg(); 
   else // perhaps not the smartest thing. but what else can we do?
   {  f.FunctionArg() << "*manage(new Gtk::Adjustment(0,0,1))";
      f.FunctionArg() << "*manage(new Gtk::Adjustment(0,0,1))";
   }
}

const std::string Gtk_Viewport::TypeName(const Widget &w) const
{  return GtkPrefix()+"Viewport";
}

const std::string Gtk_Viewport::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"viewport.h";
}

Gtk_Viewport::Gtk_Viewport()
{  Writer["GtkViewport"]=this;
}

void Gtk_Viewport::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteEnumPropertyNS(w,f,instance, "shadow_type");
}

void Gtk_Viewport::GCInclude(const Widget &w, CxxFile &f) const
{  Parent::GCInclude(w,f);
   if (GTKMM2) f.Include("gtkmm/adjustment.h");
}
