/* strutil.h - String utility functions                                                                  
 *                                                                                                       
 * Copyright (C) 2005 Oskar Liljeblad
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef COMMON_STRUTIL
#define COMMON_STRUTIL

#include <string.h>
#include <stdbool.h>

char *strdupn(const char *str, size_t n);
char *xstrdupn(const char *str, size_t n);
bool string_in_csv(const char *csv, char sep, const char *value);
bool ends_with(const char *str, const char *end);
bool ends_with_nocase(const char *str, const char *end);
size_t chomp(char *buf, size_t len);
char *concat_filenames(const char *p1, const char *p2);
void strreplace(char *str, char in, char out);

#endif
