# Macros based on the widely used Tinyfugue versions (for MOO only ?)
# This file may be overwritten when a new version of gmoo is installed

CLIENT::register_macro("e",    "e_cb",  "Edit a something");
CLIENT::register_macro("ne",   "ne_cb", "Notedit something");
CLIENT::register_macro("de",   "de_cb", "Describe an object");
CLIENT::register_macro("me",   "me_cb", "Describe yuourself");
CLIENT::register_macro("he",   "he_cb", "Describe your current location");

CLIENT::register_macro("verb",  "verb_cb", "Show all verbs on an object");
CLIENT::register_macro("verbs", "verb_cb", "Show all verbs on an object");
CLIENT::register_macro("prop",  "prop_cb", "Show all props on an object");
CLIENT::register_macro("props", "prop_cb", "Show all props on an object");

sub get_word($$)  {
  my @list = split(/ /, @_[0]);
  return $list[@_[1]];
}

sub e_cb    ($$) {
  WORLD::writeln(@_[0], '@edit ' . @_[1]);
}

sub ne_cb   ($$) {
  WORLD::writeln(@_[0], '@notedit ' . @_[1]);
}

sub de_cb   ($$) {
  WORLD::writeln(@_[0], '@notedit ' . get_word(@_[1], 0) . ".description");
}

sub me_cb   ($$) {
  WORLD::writeln(@_[0], '@notedit me.description');
}

sub he_cb   ($$) {
  WORLD::writeln(@_[0], '@notedit here.description');
}

sub verb_cb ($$) {
  WORLD::writeln(@_[0], '@d ' . get_word(@_[1], 0) . ':' );
}

sub prop_cb ($$) {
  WORLD::writeln(@_[0], '@d ' . get_word(@_[1], 0) . '.' );
}
